from typing import Any, Iterable, List, Optional, Union

from dev.coatl.helper.types import AnyStr
from java.io import Closeable
from java.lang import AutoCloseable, Class, Comparable, Enum, Object, Throwable
from java.util import Date
from org.apache.commons.lang3.builder import ToStringStyle
from org.slf4j import Logger

class LoggerEx(Object):
    DEFAULT_TO_STRING_STYLE: ToStringStyle
    def createSubLogger(self, arg: Union[Class, AnyStr]) -> LoggerEx: ...
    def debug(self, message: AnyStr, t: Optional[Throwable] = ...) -> None: ...
    def debugDuration(self, message: AnyStr) -> Closeable: ...
    def debugEvent(self, message: AnyStr, *args: Any) -> None: ...
    def debugf(self, message: AnyStr, *args: Any) -> None: ...
    def error(self, message: AnyStr, t: Optional[Throwable] = ...) -> None: ...
    def errorEvent(self, message: AnyStr, *args: Any) -> None: ...
    def errorf(self, message: AnyStr, *args: Any) -> None: ...
    def fatal(self, message: AnyStr, t: Optional[Throwable] = ...) -> None: ...
    def getIdentObject(self) -> Object: ...
    def getLoggerSLF4J(self) -> Logger: ...
    def getName(self) -> AnyStr: ...
    def getToStringStyle(self) -> ToStringStyle: ...
    def info(self, message: AnyStr, t: Optional[Throwable] = ...) -> None: ...
    def infoDuration(self, message: AnyStr) -> Closeable: ...
    def infoEvent(self, message: AnyStr, *args: Any) -> None: ...
    def infof(self, message: AnyStr, *args: Any) -> None: ...
    def isDebugEnabled(self) -> bool: ...
    def isIdentObjectEnabled(self) -> bool: ...
    def isInfoEnabled(self) -> bool: ...
    def isTraceEnabled(self) -> bool: ...
    def mdcClose(self) -> None: ...
    def mdcPut(self, key: AnyStr, value: AnyStr) -> None: ...
    def mdcPutCloseable(self, key: AnyStr, value: AnyStr) -> LoggerEx.MDCCloseable: ...
    def mdcRemove(self, key: AnyStr) -> None: ...
    def mdcSet(self) -> LoggerEx.MDCCloseable: ...
    @staticmethod
    def newBuilder() -> LoggerEx.Builder: ...
    def setIdentObject(self, identObj: Object) -> None: ...
    def setToStringStyle(self, toStringStyle: ToStringStyle) -> None: ...
    def trace(self, message: AnyStr, t: Optional[Throwable] = ...) -> None: ...
    def traceDuration(self, message: AnyStr) -> Closeable: ...
    def traceEvent(self, message: AnyStr, *args: Any) -> None: ...
    def tracef(self, message: AnyStr, *args: Any) -> None: ...
    def warn(self, message: AnyStr, t: Optional[Throwable] = ...) -> None: ...
    def warnEvent(self, message: AnyStr, *args: Any) -> None: ...
    def warnf(self, message: AnyStr, *args: Any) -> None: ...

    class Builder(Object):
        def build(self, *args: Any) -> LoggerEx: ...
        def eventSystem(self, systemId: str) -> LoggerEx.Builder: ...
        def identObject(self, identObj: Object) -> LoggerEx.Builder: ...
        def mdcContext(self, *args: Object) -> LoggerEx.Builder: ...
        def mutableIdentObject(self, identObj: Object) -> LoggerEx.Builder: ...

    class MDCCloseable(Object, AutoCloseable):
        def close(self) -> None: ...

class Platform(Object):
    LINUX_AARCH64: Platform
    LINUX_ARM: Platform
    LINUX_X64: Platform
    LINUX_X86: Platform
    OSX_X64: Platform
    OSX_X86: Platform
    WINDOWS_X64: Platform
    WINDOWS_X86: Platform
    def __init__(
        self,
        operatingSystem: Platform.OperatingSystem,
        architecture: Platform.Architecture,
    ) -> None: ...
    def getArchitecture(self) -> Platform.Architecture: ...
    @staticmethod
    def getCurrent() -> Platform: ...
    def getOperatingSystem(self) -> Platform.OperatingSystem: ...

    class Architecture(Enum):
        @staticmethod
        def fromString(s: AnyStr) -> Platform.Architecture: ...
        def getSignatures(self) -> Iterable[AnyStr]: ...
        @staticmethod
        def values() -> Iterable[Platform.Architecture]: ...

    class OperatingSystem(Enum):
        @staticmethod
        def fromString(s: AnyStr) -> Platform.OperatingSystem: ...
        def getSignatures(self) -> Iterable[AnyStr]: ...
        @staticmethod
        def values() -> Iterable[Platform.OperatingSystem]: ...

class TimelineList(Object):
    def __init__(self) -> None: ...
    def add(self, *args: Any) -> None: ...
    def covered(self, time: long) -> bool: ...
    def get(self, time: long) -> Any: ...
    def getClosest(self, time: long) -> Any: ...
    def getSegment(self, *args: Any) -> TimelineList.TimeSegment: ...
    def getSegments(self, *args: Any) -> List[TimelineList.TimeSegment]: ...
    def mergeSegments(self) -> None: ...
    def nextEvent(self, time: long, allowRollover: Optional[bool] = ...) -> bool: ...
    def size(self) -> int: ...
    def sort(self) -> None: ...

    class TimeSegment(Object, Comparable):
        def __init__(self, *args: Any) -> None: ...
        def compareTo(self, o: Any) -> int: ...
        def contains(self, time: long) -> bool: ...
        def endsBefore(self, time: long) -> bool: ...
        def getDuration(self) -> long: ...
        def getEnd(self) -> long: ...
        def getStart(self) -> long: ...
        def getValue(self) -> Any: ...
        def setEnd(self, end: long) -> None: ...
        def setStart(self, start: long) -> None: ...
        def setStartAfter(self, start: long) -> None: ...

class Timeline(TimelineList):
    def __init__(self, style: Optional[Timeline.TimelineStyle] = ...) -> None: ...
    def addSegment(self, start: long, end: long) -> None: ...
    @staticmethod
    def createParser(style: Timeline.TimelineStyle) -> Timeline.TimelineParser: ...
    def getStyle(self) -> Timeline.TimelineStyle: ...
    def invert(self) -> Timeline: ...

    class TimelineParser:
        def parse(self, input: AnyStr) -> Timeline: ...

    class TimelineStyle(Enum):
        def toDateForStyle(self, value: long) -> Date: ...
        def toLongForStyle(self, dateMillis: Union[Date, long]) -> long: ...
        @staticmethod
        def values() -> Iterable[Timeline.TimelineStyle]: ...
