from typing import Any, Iterable, List, Optional, Union

from com.inductiveautomation.ignition.common import QualifiedPath
from com.inductiveautomation.ignition.common.config import (
    BasicProperty,
    Property,
    PropertySet,
    PropertyValue,
)
from com.inductiveautomation.ignition.common.user.schedule import ScheduleAdjustment
from dev.coatl.helper.types import AnyStr
from java.lang import Object
from java.util import Date

class User:
    Badge: BasicProperty
    DEFAULT_SCHEDULE_NAME: str
    FirstName: BasicProperty
    Language: BasicProperty
    LastName: BasicProperty
    Notes: BasicProperty
    Password: BasicProperty
    Schedule: BasicProperty
    Username: BasicProperty
    USERNAME_PATTERN: str
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getId(self) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> AnyStr: ...
    def getRoles(self) -> List[AnyStr]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...

class AuthenticatedUser(User):
    SecurityZones: Property
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getId(self) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> AnyStr: ...
    def getRoles(self) -> List[AnyStr]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...

class ContactInfo(Object):
    contactType: AnyStr
    value: AnyStr
    def __init__(self, *args: Any) -> None: ...
    def getContactType(self) -> AnyStr: ...
    def getValue(self) -> AnyStr: ...
    def setContactType(self, contactType: AnyStr) -> None: ...
    def setValue(self, value: AnyStr) -> None: ...

class BasicUser(User):
    contactInfo: Optional[List[ContactInfo]]
    id: Any
    profileName: AnyStr
    roles: List[AnyStr]
    scheduleAdjustments: List[ScheduleAdjustment]
    def __init__(
        self,
        profileName: AnyStr,
        id_: Any,
        roles: List[AnyStr],
        contactInfo: Optional[List[ContactInfo]] = ...,
    ) -> None: ...
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getId(self) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> AnyStr: ...
    def getRoles(self) -> List[AnyStr]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...

class PyUser(User):
    def __init__(self, user: Optional[User] = ...) -> None: ...
    def addContactInfo(self, *args: Any) -> None: ...
    def addRole(self, role: AnyStr) -> None: ...
    def addRoles(self, roles: List[AnyStr]) -> None: ...
    def addScheduleAdjustment(
        self, start: Date, end: Date, available: bool, note: AnyStr
    ) -> None: ...
    def addScheduleAdjustments(
        self, scheduleAdjustments: List[ScheduleAdjustment]
    ) -> None: ...
    def contains(self, prop: Property) -> bool: ...
    def get(self, propertyName: Union[Property, AnyStr]) -> Any: ...
    def getContactInfo(self) -> List[ContactInfo]: ...
    def getCount(self) -> int: ...
    def getId(self) -> Any: ...
    def getOrDefault(self, prop: Property) -> Any: ...
    def getOrElse(self, property: Property, value: Any) -> Any: ...
    def getPath(self) -> QualifiedPath: ...
    def getProfileName(self) -> AnyStr: ...
    def getProperties(self) -> List[Property]: ...
    def getRoles(self) -> List[AnyStr]: ...
    def getScheduleAdjustments(self) -> List[ScheduleAdjustment]: ...
    def getValues(self) -> List[PropertyValue]: ...
    def isExtended(self, prop: Property) -> bool: ...
    def isInherited(self, prop: Property) -> bool: ...
    def iterator(self) -> Iterable[Property]: ...
    def merge(self, other: PropertySet, localOnly: bool) -> None: ...
    def remove(self, prop: Property) -> None: ...
    def removeContactInfo(self, contactType: AnyStr, value: AnyStr) -> None: ...
    def removeRole(self, role: AnyStr) -> None: ...
    def removeScheduleAdjustment(
        self, start: Date, end: Date, available: bool, note: AnyStr
    ) -> None: ...
    def set(self, *args: Any) -> None: ...
    def setContactInfo(self, contactInfo: List[ContactInfo]) -> None: ...
    def setRoles(self, roles: List[AnyStr]) -> None: ...
    def setScheduleAdjustments(
        self, scheduleAdjustments: List[ScheduleAdjustment]
    ) -> None: ...

class UserSourceMeta(Object):
    description: AnyStr
    name: AnyStr
    type: AnyStr
    def __init__(self, name: AnyStr, description: AnyStr, type_: AnyStr) -> None: ...
    def getName(self) -> AnyStr: ...
    def getDescription(self) -> AnyStr: ...
    def getType(self) -> AnyStr: ...
