from typing import Any, Optional

from com.inductiveautomation.ignition.common import Path
from com.inductiveautomation.ignition.common.browsing import BrowseFilter
from com.inductiveautomation.ignition.common.config import Property
from com.inductiveautomation.ignition.common.gson import (
    JsonDeserializationContext,
    JsonElement,
    JsonSerializationContext,
)
from com.inductiveautomation.ignition.common.user import AuthenticatedUser
from dev.coatl.helper.types import AnyStr
from java.lang import Comparable, Object
from java.lang.reflect import Type

class TagManager:
    def browseAsync(
        self,
        tagPath: TagPath,
        browseFilter: BrowseFilter,
        securityContext: Optional[SecurityContext] = ...,
    ) -> Any: ...

class SecurityContext(Object):
    @staticmethod
    def emptyContext() -> SecurityContext: ...
    @staticmethod
    def fromAuthenticatedUser(user: AuthenticatedUser) -> SecurityContext: ...

    class GsonAdapter(Object):
        def __init__(self) -> None: ...
        def deserialize(
            self,
            jsonElement: JsonElement,
            type_: Type,
            jsonDeserializationContext: JsonDeserializationContext,
        ) -> SecurityContext: ...
        def serialize(
            self,
            securityContext: SecurityContext,
            type_: Type,
            jsonSerializationContext: JsonSerializationContext,
        ) -> JsonElement: ...

class TagPath(Path, Comparable):
    def compareTo(self, o: TagPath) -> int: ...
    def getChildPath(self, nextId: AnyStr) -> TagPath: ...
    def getItemName(self) -> AnyStr: ...
    def getLastPathComponent(self) -> AnyStr: ...
    def getParentPath(self) -> TagPath: ...
    def getPathComponent(self, i: int) -> AnyStr: ...
    def getPathLength(self) -> int: ...
    def getProperty(self) -> Property: ...
    def getSource(self) -> AnyStr: ...
    def isAncestorOf(self, path: Path) -> bool: ...
    def toStringFull(self) -> AnyStr: ...
    def toStringPartial(self) -> AnyStr: ...
