from typing import Iterable, List, Optional

from com.inductiveautomation.ignition.common.i18n import LocalizedString
from com.inductiveautomation.ignition.common.model.values import Quality, QualityCode
from dev.coatl.helper.types import AnyStr
from java.lang import Class, Enum, Object
from java.util import Locale

class DataQuality(Object):
    @staticmethod
    def fromIntValue(value: int) -> DataQuality: ...
    def getDescription(self) -> LocalizedString: ...
    def getIntValue(self) -> int: ...
    def getLevel(self) -> Quality.Level: ...
    def getName(self) -> str: ...
    def getQualityCode(self) -> QualityCode: ...
    @staticmethod
    def getQualityFor(value: int) -> DataQuality: ...
    def isDataUsed(self) -> bool: ...
    def isGood(self) -> bool: ...
    def isGoodData(self) -> bool: ...
    def isOpcBadData(self) -> bool: ...
    def toString(self, locale: Optional[Locale] = ...) -> AnyStr: ...
    @staticmethod
    def valueOf(name: str) -> DataQuality: ...
    @staticmethod
    def values() -> List[DataQuality]: ...
    @staticmethod
    def worstOf(q1: DataQuality, q2: DataQuality) -> DataQuality: ...
    @staticmethod
    def worstOfAll(*args: DataQuality) -> DataQuality: ...

class DataType(Enum):
    @staticmethod
    def fromIntValue(val: int) -> DataType: ...
    def getComponentDataType(self) -> DataType: ...
    def getIntValue(self) -> int: ...
    def getJavaType(self) -> Class: ...
    def getTypeClass(self) -> DataTypeClass: ...
    @staticmethod
    def getTypeForClass(clazz: Class) -> DataType: ...
    @staticmethod
    def getTypeForValue(val: int) -> DataType: ...
    def isArray(self) -> bool: ...
    def isFloatingPoint(self) -> bool: ...
    def isNumeric(self) -> bool: ...
    def legacyDataType(self) -> DataType: ...
    @staticmethod
    def values() -> Iterable[DataType]: ...

class DataTypeClass(Enum):
    @staticmethod
    def values() -> Iterable[DataTypeClass]: ...
