from typing import Any, Union

from com.inductiveautomation.ignition.common import QualifiedPath
from com.inductiveautomation.ignition.common.gson import JsonElement
from dev.coatl.helper.types import AnyStr
from java.lang import Object
from java.util import Date

class Annotation(Object):
    def __init__(self) -> None: ...
    def clone(self) -> Annotation: ...
    def delete(self) -> None: ...
    @staticmethod
    def fromJson(json: JsonElement) -> Annotation: ...
    def getData(self) -> AnyStr: ...
    def getLastUpdated(self) -> Date: ...
    def getPath(self) -> QualifiedPath: ...
    def getRangeEnd(self) -> Date: ...
    def getRangeStart(self) -> Date: ...
    def getStorageId(self) -> Any: ...
    def getType(self) -> AnyStr: ...
    def hasStorageId(self) -> bool: ...
    def isDeleted(self) -> bool: ...
    def isUpdated(self) -> bool: ...
    @staticmethod
    def newBuilder() -> Annotation.Builder: ...
    @staticmethod
    def newDelete(storageId: Any) -> Annotation: ...
    def toJson(self) -> AnyStr: ...
    def updatePath(self, path: QualifiedPath) -> None: ...

    class Builder(Object):
        def build(self) -> Annotation: ...
        def copy(self, ann: Annotation) -> Annotation.Builder: ...
        def data(self, value: AnyStr) -> Annotation.Builder: ...
        def delete(self) -> Annotation.Builder: ...
        def end(self, time: Date) -> Annotation.Builder: ...
        def lastUpdated(self, time: Date) -> Annotation.Builder: ...
        def path(self, path: QualifiedPath) -> Annotation.Builder: ...
        def start(self, time: Date) -> Annotation.Builder: ...
        def storageId(self, id_: Any) -> Annotation.Builder: ...
        def time(self, time: Date) -> Annotation.Builder: ...
        def type(self, arg: Union[AnnotationType, AnyStr]) -> Annotation.Builder: ...

class AnnotationType(Object):
    def __init__(self, type_: AnyStr, isRange: bool) -> None: ...
