from typing import Optional

from com.inductiveautomation.ignition.common.opc import BrowseElementType
from com.inductiveautomation.ignition.common.sqltags.model.types import DataType
from com.inductiveautomation.ignition.common.tags.config.types import TagObjectType
from dev.coatl.helper.types import AnyStr
from java.lang import Class, Object

class BrowseTag(Object):
    dataType: DataType
    name: AnyStr
    fullPath: AnyStr
    path: AnyStr
    type: TagObjectType
    valueSource: AnyStr
    def __init__(
        self,
        name: str,
        path: str,
        fullPath: str,
        type_: TagObjectType,
        valueSource: str,
        dataType: DataType,
    ) -> None: ...
    def getDataType(self) -> DataType: ...
    def getFullPath(self) -> AnyStr: ...
    def getPath(self) -> AnyStr: ...
    def getTagType(self) -> TagObjectType: ...
    def getValueSource(self) -> AnyStr: ...
    def isDB(self) -> bool: ...
    def isExpression(self) -> bool: ...
    def isFolder(self) -> bool: ...
    def isMemory(self) -> bool: ...
    def isOPC(self) -> bool: ...
    def isQuery(self) -> bool: ...
    def isUDT(self) -> bool: ...

class OPCBrowseTag(Object):
    def __init__(
        self,
        opcServer: Optional[str] = ...,
        type_: Optional[BrowseElementType] = ...,
        displayName: Optional[str] = ...,
        displayPath: Optional[str] = ...,
        dataType: Optional[Class] = ...,
        opcItemPath: Optional[str] = ...,
    ) -> None: ...
    def getDataType(self) -> Optional[Class]: ...
    def getDisplayName(self) -> Optional[str]: ...
    def getDisplayPath(self) -> Optional[str]: ...
    def getOpcItemPath(self) -> Optional[str]: ...
    def getOpcServer(self) -> Optional[str]: ...
    def getType(self) -> Optional[BrowseElementType]: ...
