from copy import PyStringMap
from typing import Any, List, Mapping, Optional, Set

from com.codahale.metrics import Timer
from com.inductiveautomation.ignition.common.script.hints import ScriptFunctionHint
from dev.coatl.helper.types import AnyStr
from java.io import OutputStream
from java.lang import Class, Object
from java.util import UUID
from org.python.core import PyObject, PySystemState

class ScriptFunction:
    def invoke(self, *args: Any) -> PyObject: ...

class ScriptManager(Object):
    def __init__(self, contextName: AnyStr, pathToExternalLibs: AnyStr) -> None: ...
    def addGlobalVariable(self, name: AnyStr, value: PyObject) -> None: ...
    def addScriptModule(self, *args: Any) -> None: ...
    def addStaticFields(self, path: AnyStr, clazz: Class) -> None: ...
    def addStdErrStream(self, os: OutputStream) -> None: ...
    def addStdOutStream(self, os: OutputStream) -> None: ...
    @staticmethod
    def asynchInit(pathToExternalLibs: Optional[AnyStr] = ...) -> None: ...
    def beginCompileTimer(self) -> Timer.Context: ...
    def clearAppModule(self) -> None: ...
    def clearModule(self, moduleName: AnyStr) -> None: ...
    def clearProjectScriptModules(self) -> None: ...
    def clearThirdPartyModules(self) -> None: ...
    def compileFunction(self, *args: Any) -> ScriptFunction: ...
    def createLocalsMap(self) -> PyStringMap: ...
    @staticmethod
    def createUtf8PySystemState(
        stdOut: OutputStream, stdErr: OutputStream
    ) -> PySystemState: ...
    @staticmethod
    def executingScripts() -> Set[ScriptManager.ExecutionInfo]: ...
    def getCompileTimer(self) -> Timer: ...
    def getExecutionTimer(self) -> Timer: ...
    def getGlobals(self) -> PyStringMap: ...
    def getHintsMap(self) -> Mapping[AnyStr, List[ScriptFunctionHint]]: ...
    def getModules(self) -> PyStringMap: ...
    def getUUID(self) -> UUID: ...
    @staticmethod
    def interrupt(threadId: long) -> None: ...
    @staticmethod
    def main(*args: AnyStr) -> None: ...
    def removeStdErrStream(self, os: OutputStream) -> None: ...
    def removeStdOutStream(self, os: OutputStream) -> None: ...
    def runCode(self, *args: Any) -> None: ...
    def runFunction(self, *args: Any) -> PyObject: ...
    def setContextName(self, name: AnyStr) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def shutdown(self) -> None: ...
    def validatePackageName(self, newName: AnyStr) -> None: ...

    class ExecutionInfo(Object):
        description: AnyStr
        startTime: long
        threadId: long
