from typing import Iterable, List, Optional, Set

from com.inductiveautomation.ignition.common.project.resource import (
    ProjectResource,
    ProjectResourceId,
    ResourceSignature,
)
from com.inductiveautomation.ignition.gateway.project import ResourceFilter
from dev.coatl.helper.types import AnyStr
from java.lang import Enum, Object

class Project:
    def addProjectResourceListener(self, listener: ProjectResourceListener) -> None: ...

class ProjectResourceListener:
    def getResourceFilter(self) -> ResourceFilter: ...
    def manifestChanged(
        self,
        projectName: AnyStr,
        operation: List[ChangeOperation.ManifestChangeOperation],
    ) -> None: ...
    def onAfterChanges(self) -> None: ...
    def onBeforeChanges(self) -> None: ...
    def resourcesCreated(
        self,
        projectName: AnyStr,
        resources: List[ChangeOperation.CreateResourceOperation],
    ) -> None: ...
    def resourcesDeleted(
        self,
        projectName: AnyStr,
        resources: List[ChangeOperation.DeleteResourceOperation],
    ) -> None: ...
    def resourcesModified(
        self,
        projectName: AnyStr,
        resources: List[ChangeOperation.ModifyResourceOperation],
    ) -> None: ...

class ChangeOperation(Object):
    @staticmethod
    def changeOpsToIdSet(changes: List[ChangeOperation]) -> Set[ProjectResourceId]: ...
    def getOperationType(self) -> ChangeOperation.OperationType: ...
    def getProjectName(self) -> AnyStr: ...
    @staticmethod
    def getResourceFromChange(op: ChangeOperation) -> ProjectResource: ...
    @staticmethod
    def getResourceIdFromChange(op: ChangeOperation) -> ProjectResourceId: ...
    @staticmethod
    def newCreateOp(
        resource: ProjectResource,
    ) -> ChangeOperation.CreateResourceOperation: ...
    @staticmethod
    def newDeleteOp(
        resourceSignature: ResourceSignature,
    ) -> ChangeOperation.DeleteResourceOperation: ...
    @staticmethod
    def newManifestChangeOp(
        projectName: AnyStr,
        manifest: ProjectManifest,
        baseHashCode: Optional[int] = ...,
    ) -> ChangeOperation.ManifestChangeOperation: ...
    @staticmethod
    def newModifyOp(
        resource: ProjectResource, baseSignature: ResourceSignature
    ) -> ModifyResourceOperation: ...

    class CreateResourceOperation(Object):
        def getResource(self) -> ProjectResource: ...
        def getResourceId(self) -> ProjectResourceId: ...

    class DeleteResourceOperation(Object):
        def getResourceId(self) -> ProjectResourceId: ...
        def getResourceSignature(self) -> ResourceSignature: ...

    class ManifestChangeOperation(Object):
        def getBaseHashCode(self) -> int: ...
        def getManifest(self) -> ProjectManifest: ...
        def getProjectName(self) -> AnyStr: ...

    class ModifyResourceOperation(Object):
        def getBaseSignature(self) -> ResourceSignature: ...
        def getResource(self) -> ProjectResource: ...
        def getResourceId(self) -> ProjectResourceId: ...

    class OperationType(Enum):
        @staticmethod
        def values() -> Iterable[ChangeOperation.OperationType]: ...

    class ResourceChangeOperation(Object):
        def getProjectName(self) -> AnyStr: ...
        def getResourceId(self) -> ProjectResourceId: ...

class ProjectManifest(Object):
    def __init__(
        self,
        title: AnyStr,
        description: AnyStr,
        enabled: bool,
        inheritable: bool,
        parent: AnyStr,
    ) -> None: ...
