from typing import Any, Iterable, Union

from com.inductiveautomation.ignition.common.gson import JsonObject
from dev.coatl.helper.types import AnyStr
from java.lang import Enum, Object
from java.util import Date

class QualifiedValue:
    def derive(self, arg: Union[None, QualityCode, AnyStr] = ...) -> QualifiedValue: ...
    def getQuality(self) -> QualityCode: ...
    def getTimestamp(self) -> Date: ...
    def getValue(self) -> Object: ...

class Quality:
    def getDescription(self) -> AnyStr: ...
    def getLevel(self) -> Quality.Level: ...
    def getName(self) -> AnyStr: ...
    def getQualityCode(self) -> QualityCode: ...
    def isGood(self) -> bool: ...

    class Level(Enum):
        Bad: int
        Good: int
        Unknown: int
        @staticmethod
        def values() -> Iterable[Quality.Level]: ...

class QualityCode(Object):
    Bad: QualityCode
    Bad_AccessDenied: QualityCode
    Bad_AggregateNotFound: QualityCode
    Bad_DatabaseNotConnected: QualityCode
    Bad_Disabled: QualityCode
    Bad_Failure: QualityCode
    Bad_GatewayCommOff: QualityCode
    Bad_LicenseExceeded: QualityCode
    Bad_NotConnected: QualityCode
    Bad_NotFound: QualityCode
    Bad_OutOfRange: QualityCode
    Bad_ReadOnly: QualityCode
    Bad_Stale: QualityCode
    Bad_ReferenceNotFound: QualityCode
    Bad_TrialExpired: QualityCode
    Bad_Unauthorized: QualityCode
    Bad_Unsupported: QualityCode
    Error: QualityCode
    Error_Configuration: QualityCode
    Error_CycleDetected: QualityCode
    Error_DatabaseQuery: QualityCode
    Error_Exception: QualityCode
    Error_ExpressionEval: QualityCode
    Error_Formatting: QualityCode
    Error_InvalidPathSyntax: QualityCode
    Error_IO: QualityCode
    Error_ScriptEval: QualityCode
    Error_TagExecution: QualityCode
    Error_TimeoutExpired: QualityCode
    Error_TypeConversion: QualityCode
    Good: QualityCode
    Good_Backfill: QualityCode
    Good_Initial: QualityCode
    Good_Overload: QualityCode
    Good_Provisional: QualityCode
    Good_Unspecified: QualityCode
    Good_WritePending: QualityCode
    Uncertain: QualityCode
    Uncertain_LastKnownValue: QualityCode
    Uncertain_InitialValue: QualityCode
    Uncertain_DataSubNormal: QualityCode
    Uncertain_EngineeringUnitsExceeded: QualityCode
    Uncertain_IncompleteOperation: QualityCode
    def __init__(self, *args: Any) -> None: ...
    def derive(self, diagnosticMessage: AnyStr) -> QualityCode: ...
    def getCode(self) -> int: ...
    @staticmethod
    def getCodeName(code: Union[int, QualityCode]) -> AnyStr: ...
    @staticmethod
    def getCodesJson() -> JsonObject: ...
    def getDiagnosticMessage(self) -> AnyStr: ...
    def getLevel(self) -> QualityCode.Level: ...
    def getName(self) -> AnyStr: ...
    def isBad(self) -> bool: ...
    def isBadOrError(self) -> bool: ...
    def isError(self) -> bool: ...
    def isGood(self) -> bool: ...
    def isNotGood(self) -> bool: ...
    def isUncertain(self) -> bool: ...

    class Level(Enum):
        def code(self, userCode: int) -> int: ...
        @staticmethod
        def values() -> Iterable[QualityCode.Level]: ...

class BasicQualifiedValue(QualifiedValue, Object):
    quality: QualityCode
    timestamp: Date
    value: Object
    def __init__(self, *args: Any) -> None: ...
    def BAD(self) -> BasicQualifiedValue: ...
    def CONFIG_ERROR(self) -> BasicQualifiedValue: ...
    def DISABLED(self) -> BasicQualifiedValue: ...
    def EXPRESSION_EVAL_ERROR(self) -> BasicQualifiedValue: ...
    def INITIAL_VALUE(self) -> BasicQualifiedValue: ...
    def NOT_CONNECTED(self) -> BasicQualifiedValue: ...
    def NOT_FOUND(self) -> BasicQualifiedValue: ...
    def REFERENCE_NOT_FOUND(self) -> BasicQualifiedValue: ...
    def STALE(self) -> BasicQualifiedValue: ...
    def TRANSFORM_ERROR(self) -> BasicQualifiedValue: ...
    def TYPE_CONVERSION(self) -> BasicQualifiedValue: ...
    def UNKNOWN(self) -> BasicQualifiedValue: ...
    def UNSUPPORTED(self) -> BasicQualifiedValue: ...
    def clone(self) -> BasicQualifiedValue: ...
    def derive(self, arg: Union[None, QualityCode, AnyStr] = ...) -> QualifiedValue: ...
    @staticmethod
    def fromObject(obj: Object) -> QualifiedValue: ...
    def getQuality(self) -> QualityCode: ...
    def getTimestamp(self) -> Date: ...
    def getValue(self) -> Object: ...
    def setQuality(self, code: QualityCode) -> None: ...
    def setTimestamp(self, timestamp: Date) -> None: ...
    def setValue(self, value: Object) -> None: ...
    @staticmethod
    def unwrap(obj: Object) -> Object: ...
    @staticmethod
    def updateTimestamp(copy: QualifiedValue) -> QualifiedValue: ...
    @staticmethod
    def valueOf(obj: Object) -> Object: ...
