from typing import Any, Iterable, List, Optional, Tuple, Union

from com.google.common.eventbus import EventBus
from com.inductiveautomation.ignition.common.expressions import FunctionFactory
from com.inductiveautomation.ignition.common.licensing import LicenseState
from com.inductiveautomation.ignition.common.logging import LogFilterSettings
from com.inductiveautomation.ignition.common.script import ScriptManager
from com.inductiveautomation.ignition.common.tags.model import TagManager
from com.inductiveautomation.ignition.common.xmlserialization.deserialization import (
    XMLDeserializer,
)
from dev.coatl.helper.types import AnyStr
from java.io import InputStream
from java.lang import Enum, Object, String

class CommonContext:
    def createDeserializer(self) -> XMLDeserializer: ...
    def getEdgeEditions(self) -> List[EdgeEdition]: ...
    def getEventBus(self) -> EventBus: ...
    def getExpressionFunctionFactory(self) -> FunctionFactory: ...
    def getLicenseState(self, moduleId: AnyStr) -> LicenseState: ...
    def getLoggingManager(self) -> LogFilterSettings: ...
    def getModule(self, id_: AnyStr) -> Object: ...
    def getScriptManager(self) -> ScriptManager: ...
    def getTagManager(self) -> TagManager: ...

class ApplicationScope(Object):
    ALL: int
    CLIENT: int
    DESIGNER: int
    GATEWAY: int
    NONE: int
    @staticmethod
    def getGlobalScope() -> int: ...
    @staticmethod
    def getScopePrefix() -> AnyStr: ...
    @staticmethod
    def init(globalScope: int) -> None: ...
    @staticmethod
    def isClient(scope: int) -> bool: ...
    @staticmethod
    def isDesigner(scope: int) -> bool: ...
    @staticmethod
    def isGateway(scope: int) -> bool: ...
    @staticmethod
    def parseScope(s: AnyStr) -> int: ...
    @staticmethod
    def toCode(scope: int) -> AnyStr: ...

class EdgeEdition(Enum):
    @staticmethod
    def create(edgeFlags: List[String]) -> List[EdgeEdition]: ...
    @staticmethod
    def getAllEditions() -> List[EdgeEdition]: ...
    @staticmethod
    def values() -> Iterable[EdgeEdition]: ...

class Version(Object):
    build: int
    dev: bool
    major: int
    minor: int
    rev: int
    beta: int
    rc: int
    snapshot: bool
    def __init__(
        self,
        major: int = ...,
        minor: int = ...,
        rev: int = ...,
        build: int = ...,
        beta: int = ...,
        rc: int = ...,
    ) -> None: ...
    def __eq__(self, other: Any) -> bool: ...
    def compareTo(self, that: Version) -> Optional[int]: ...
    def exists(self) -> bool: ...
    @staticmethod
    def fromXML(inputStream: InputStream) -> Version: ...
    def getBasicString(self) -> str: ...
    def getBeta(self) -> int: ...
    def getBuildNumber(self) -> int: ...
    def getMajor(self) -> int: ...
    def getMinor(self) -> int: ...
    def getRc(self) -> int: ...
    def getRevision(self) -> int: ...
    def getXML(self) -> str: ...
    def isDev(self) -> bool: ...
    def isFutureVersion(self, arg: Union[Version, AnyStr]) -> bool: ...
    def isSnapshot(self) -> bool: ...
    @staticmethod
    def parse(s: AnyStr) -> Version: ...
    def toParseableString(self) -> str: ...
    def toString(self) -> str: ...
    def toTuple(self, strict: bool = ...) -> Tuple[int, ...]: ...
