from typing import Any, Dict, List, Optional, Set, Tuple

from com.inductiveautomation.ignition.common import JsonPath
from com.inductiveautomation.ignition.common.gson import JsonArray, JsonElement
from dev.coatl.helper.types import AnyStr
from java.io import InputStream
from java.lang import Enum, Object
from java.util.regex import Pattern

class JsonValidator:
    AT_ROOT: AnyStr
    def validate(self, *args: Any) -> Set[ValidationMessage]: ...

class BaseJsonValidator(Object, JsonValidator):
    def __init__(self, *args: Any) -> None: ...
    def asInt(self, element: JsonElement) -> int: ...
    def validate(self, *args: Any) -> Set[ValidationMessage]: ...

class ItemsValidator(BaseJsonValidator):
    PROPERTY: AnyStr
    def __init__(self, *args: Any) -> None: ...
    def deriveDefaultArray(self, includeExample: Optional[bool] = ...) -> JsonArray: ...
    def findSchemaForIndex(self, index: int) -> Optional[JsonSchema]: ...
    def getDefaultItem(self) -> Optional[JsonElement]: ...
    def getSchemas(self) -> List[JsonSchema]: ...
    def isBoundedSchema(self) -> Set[ValidationMessage]: ...

class JsonSchema(BaseJsonValidator):
    IGNITION_SCHEMA_PATTERN: Pattern
    IGNITION_SCHEMA_URN: AnyStr
    def __init__(self, *args: Any) -> None: ...
    def acceptsType(self, type: JsonType) -> bool: ...
    def findAncestor(self) -> JsonSchema: ...
    def findAncestorMatchingPath(
        self, matchingPath: AnyStr
    ) -> Optional[JsonSchema]: ...
    def findSchemaForPath(self, path: JsonPath) -> Optional[JsonSchema]: ...
    def getChildDefaultValue(self, type: JsonType) -> Optional[JsonElement]: ...
    def getDeclaredProperties(self) -> List[AnyStr]: ...
    def getDefaultValue(self, includeExamples: Optional[bool] = ...) -> JsonElement: ...
    def getDescription(self) -> AnyStr: ...
    def getDynamicSuggestionPath(self) -> AnyStr: ...
    def getEnumChoices(self) -> Dict[AnyStr, JsonElement]: ...
    def getExamples(self) -> List[JsonElement]: ...
    def getExampleValue(self) -> Optional[JsonElement]: ...
    def getExtension(self, key: AnyStr) -> Optional[JsonElement]: ...
    def getFormat(self) -> AnyStr: ...
    def getItemsValidator(self) -> ItemsValidator: ...
    def getRefSchemaNode(self, ref: Optional[AnyStr] = ...) -> JsonElement: ...
    def getSchemasForItems(self) -> List[JsonSchema]: ...
    def getSchemasForProperties(self) -> Dict[AnyStr, JsonSchema]: ...
    def getSuggestions(self) -> Dict[AnyStr, JsonElement]: ...
    def getTitle(self) -> AnyStr: ...
    def getTypeValidator(self) -> TypeValidator: ...
    def getVisibleWhenCondition(self) -> Optional[Tuple[AnyStr, List[JsonElement]]]: ...
    def hasChildren(self) -> bool: ...
    def isDeprecated(self) -> bool: ...
    def isType(self, type: JsonType) -> bool: ...
    @staticmethod
    def parse(stream: InputStream) -> JsonSchema: ...

class JsonType(Enum):
    OBJECT: str
    ARRAY: str
    STRING: str
    NUMBER: str
    INTEGER: str
    BOOLEAN: str
    NULL: str
    DATASET: str
    DATE: str
    UNKNOWN: str
    @staticmethod
    def typeOf(element: JsonElement) -> JsonType: ...
    @staticmethod
    def values() -> List[JsonType]: ...

class ValidationMessage(Object):
    def getCode(self) -> AnyStr: ...
    def getMessage(self) -> AnyStr: ...
    def getPath(self) -> AnyStr: ...
    def getType(self) -> AnyStr: ...
    def setArguments(self, *args: AnyStr) -> None: ...
    def setType(self, type: AnyStr) -> None: ...

    class Builder(Object):
        def arguments(self, *args: AnyStr) -> ValidationMessage.Builder: ...
        def build(self) -> ValidationMessage: ...
        def code(self, code: AnyStr) -> ValidationMessage.Builder: ...
        def format(self, format: AnyStr) -> ValidationMessage.Builder: ...
        def path(self, path: AnyStr) -> ValidationMessage.Builder: ...
        def type(self, type: AnyStr) -> ValidationMessage.Builder: ...

class TypeValidator(BaseJsonValidator):
    def __init__(self, *args: Any) -> None: ...
    def getAcceptedTypes(self) -> Set[JsonType]: ...
