from typing import Any, Iterable, Set

from com.inductiveautomation.ignition.common.binding import InteractionListener
from com.inductiveautomation.ignition.common.expressions.functions import Function
from com.inductiveautomation.ignition.common.model.values import QualifiedValue
from dev.coatl.helper.types import AnyStr
from java.lang import Class

class Expression:
    def connect(self, context: Any, updateListener: InteractionListener) -> None: ...
    def disconnect(self) -> None: ...
    def execute(self, args: Iterable[Expression]) -> QualifiedValue: ...
    def getChildren(self) -> Iterable[Expression]: ...
    def getOpName(self) -> AnyStr: ...
    def getType(self) -> Class: ...
    def shutdown(self) -> None: ...
    def startup(self) -> None: ...

class FunctionFactory:
    def getCategories(self) -> Set[AnyStr]: ...
    def getFunction(self, name: AnyStr) -> Function: ...
    def getFunctionNames(self) -> Set[AnyStr]: ...
    def getFunctionsInCategory(self, name: AnyStr) -> Set[AnyStr]: ...
