from typing import Any, Iterable, List, Mapping, Optional, Sequence

from com.inductiveautomation.ignition.common import Path, QualifiedPath
from com.inductiveautomation.ignition.common.config import Property, PropertyValueSource
from com.inductiveautomation.ignition.common.model.values import QualityCode
from dev.coatl.helper.types import AnyStr
from java.lang import Object

class Result:
    def getDisplayPath(self) -> Path: ...
    def getPath(self) -> QualifiedPath: ...
    def getType(self) -> AnyStr: ...
    def hasChildren(self) -> bool: ...

class BrowseFilter(Object):
    def addExcludeProperty(self, property: Property, value: Object) -> None: ...
    def addNameFilter(self, typeId: AnyStr, *filters: AnyStr) -> BrowseFilter: ...
    def addProperty(self, property: Property, value: Object) -> None: ...
    def checkNameFilters(self, path: Any) -> bool: ...
    def checkProperties(self, toCheck: PropertyValueSource) -> bool: ...
    def getAllowedTypes(self) -> Iterable[AnyStr]: ...
    def getContinuationPoint(self) -> AnyStr: ...
    def getFilterExcludeProperty(
        self, property: Property
    ) -> BrowseFilter.FilterPropertyValue: ...
    def getFilterProperty(
        self, property: Property
    ) -> BrowseFilter.FilterPropertyValue: ...
    def getMaxResults(self) -> int: ...
    def getMeta(self) -> BrowseFilter.Meta: ...
    def getNameFilters(self) -> Iterable[BrowseFilter.NameFilter]: ...
    def getNameFiltersAsMap(self) -> Mapping[AnyStr, BrowseFilter.NameFilter]: ...
    def getOffset(self) -> int: ...
    def isEmptyFilter(self) -> bool: ...
    def isRecursive(self) -> bool: ...
    def setAllowedTypes(self, allowedTypes: Iterable[AnyStr]) -> BrowseFilter: ...
    def setContinuationPoint(self, continuationPoint: AnyStr) -> BrowseFilter: ...
    def setMaxResults(self, maxResults: int) -> BrowseFilter: ...
    def setMeta(self, meta: BrowseFilter.Meta) -> None: ...
    def setNameFilters(
        self, filters: Iterable[BrowseFilter.NameFilter]
    ) -> BrowseFilter: ...
    def setOffset(self, offset: int) -> BrowseFilter: ...
    def setRecursive(self, recursive: bool) -> BrowseFilter: ...

    class FilterPropertyValue(Object):
        property: Property
        value: Object
        def __init__(self, property: Property, value: Object) -> None: ...

    class Meta(Object):
        addFolderOverrides: bool
        def __init__(self, addFolderOverrides: bool) -> None: ...

    class NameFilter(Object):
        def __init__(self, typeId: AnyStr, *filters: AnyStr) -> None: ...
        def getFilters(self) -> Iterable[AnyStr]: ...
        def getTypeId(self) -> AnyStr: ...
        def passes(self, value: AnyStr) -> bool: ...

class Results(Object):
    continuationPoint: Optional[AnyStr]
    resultQuality: QualityCode
    results: Sequence[Any]
    totalAvailableResults: int
    def __init__(self, *args: Any) -> None: ...
    @staticmethod
    def error(result: Results) -> Results: ...
    def getContinuationPoint(self) -> Optional[AnyStr]: ...
    def getResultQuality(self) -> QualityCode: ...
    def getResults(self) -> Sequence[Any]: ...
    def getReturnedSize(self) -> int: ...
    def getTotalAvailableSize(self) -> int: ...
    @staticmethod
    def of(results: List[Any]) -> Results: ...
    def setContinuationPoint(
        self, continuationPoint: Optional[AnyStr] = ...
    ) -> None: ...
    def setResultQuality(self, value: QualityCode) -> None: ...
    def setResults(self, results: List[Any]) -> None: ...
    def setTotalAvailableResults(self, totalAvailableResults: int) -> None: ...
