from typing import Any, Iterator

from com.inductiveautomation.ignition.common import QualifiedPath, StringPath
from com.inductiveautomation.ignition.common.config import BasicPropertySet
from dev.coatl.helper.types import AnyStr
from java.lang import Object
from java.util import UUID
from org.python.core import PyObject

class AlarmEvent:
    def __iter__(self) -> Iterator[Any]: ...
    def acknowledge(self, ackData: EventData) -> None: ...
    def active(self, activeData: EventData) -> None: ...
    def clear(self, clearData: EventData) -> None: ...
    def getAckData(self) -> EventData: ...
    def getActiveData(self) -> EventData: ...
    def getClearedData(self) -> EventData: ...
    def getDisplayPath(self) -> StringPath: ...
    def getDisplayPathOrSource(self) -> AnyStr: ...
    def getId(self) -> UUID: ...
    def getLabel(self) -> AnyStr: ...
    def getLastEventState(self) -> Any: ...
    def getName(self) -> AnyStr: ...
    def getNotes(self) -> AnyStr: ...
    def getPriority(self) -> Any: ...
    def getSource(self) -> QualifiedPath: ...
    def getState(self) -> Any: ...
    def isAcked(self) -> bool: ...
    def isCleared(self) -> bool: ...
    def isShelved(self) -> bool: ...
    def iterator(self) -> Any: ...

class EventData(BasicPropertySet):
    def __init__(self, *args: Any) -> None: ...
    def getTimeStamp(self) -> long: ...

class PyAlarmEvent(AlarmEvent):
    def __iter__(self) -> Iterator[Any]: ...
    def acknowledge(self, ackData: EventData) -> None: ...
    def active(self, activeData: EventData) -> None: ...
    def clear(self, clearData: EventData) -> None: ...
    def contains(self, property: AnyStr) -> bool: ...
    def get(self, property: AnyStr) -> Object: ...
    def getAckData(self) -> EventData: ...
    def getActiveData(self) -> EventData: ...
    def getClearedData(self) -> EventData: ...
    def getDisplayPath(self) -> StringPath: ...
    def getDisplayPathOrSource(self) -> AnyStr: ...
    def getId(self) -> UUID: ...
    def getLabel(self) -> AnyStr: ...
    def getLastEventState(self) -> Any: ...
    def getName(self) -> AnyStr: ...
    def getNotes(self) -> AnyStr: ...
    def getOrDefault(self, property: AnyStr) -> Object: ...
    def getOrElse(self, property: AnyStr, defaultValue: Object) -> Object: ...
    def getPriority(self) -> Any: ...
    def getSource(self) -> QualifiedPath: ...
    def getState(self) -> Any: ...
    def isAcked(self) -> bool: ...
    def isCleared(self) -> bool: ...
    def isShelved(self) -> bool: ...
    def set(self, property: AnyStr, value: Object) -> None: ...
    def setGlobal(self, property: AnyStr, value: Object) -> None: ...
    def sourceEvent(self) -> AlarmEvent: ...

class PyAlarmEventImpl(PyAlarmEvent, PyObject):
    def __init__(self, event: AlarmEvent) -> None: ...
    def contains(self, property: AnyStr) -> bool: ...
    def get(self, property: AnyStr) -> Object: ...
    def getOrDefault(self, property: AnyStr) -> Object: ...
    def getOrElse(self, property: AnyStr, defaultValue: Object) -> Object: ...
    def set(self, property: AnyStr, value: Object) -> None: ...
    def setGlobal(self, property: AnyStr, value: Object) -> None: ...
    def sourceEvent(self) -> AlarmEvent: ...
