from typing import Any, Iterable, List, Optional, Set, Union

from com.inductiveautomation.ignition.common.document import DocumentElement
from com.inductiveautomation.ignition.common.gson import Gson, JsonElement
from dev.coatl.helper.types import AnyStr
from java.awt import Color
from java.lang import Class, Comparable, Number, Object
from java.util import UUID, Comparator, Date, Locale
from org.json import JSONObject
from org.python.core import PyObject

class Dataset:
    def binarySearch(self, column: int, key: Any) -> int: ...
    def getColumnAsList(self, col: int) -> List[Any]: ...
    def getColumnCount(self) -> int: ...
    def getColumnIndex(self, colName: AnyStr) -> int: ...
    def getColumnName(self, col: int) -> AnyStr: ...
    def getColumnNames(self) -> List[AnyStr]: ...
    def getColumnType(self, col: int) -> Class: ...
    def getColumnTypes(self) -> List[Class]: ...
    def getPrimitiveValueAt(self, row: int, col: int) -> float: ...
    def getQualityAt(self, row: int, col: int) -> Any: ...
    def getRowCount(self) -> int: ...
    def getValueAt(self, row: int, col: Union[int, AnyStr]) -> Any: ...
    def hasQualityData(self) -> bool: ...

class AbstractDataset(Dataset):
    def __init__(
        self,
        columnNames: List[AnyStr],
        columnTypes: List[Class],
        qualityCodes: Optional[List[List[Any]]] = ...,
    ) -> None: ...
    @staticmethod
    def convertToQualityCodes(dataQualities: List[List[Any]]) -> List[List[Any]]: ...
    def getBulkQualityCodes(self) -> List[List[Any]]: ...
    def getColumnCount(self) -> int: ...
    def getColumnIndex(self, colName: AnyStr) -> int: ...
    def getColumnName(self, col: int) -> AnyStr: ...
    def getColumnNames(self) -> List[AnyStr]: ...
    def getColumnType(self, col: int) -> Class: ...
    def getColumnTypes(self) -> List[Class]: ...
    def getPrimitiveValueAt(self, row: int, col: int) -> float: ...
    def getQualityAt(self, row: int, col: int) -> Any: ...
    def getRowCount(self) -> int: ...
    def getValueAt(self, row: int, col: Union[int, AnyStr]) -> Any: ...
    def setColumnNames(self, arg: List[str]) -> None: ...
    def setColumnTypes(self, arg: List[Class]) -> None: ...
    def setDirty(self) -> None: ...

class BasicDataset(AbstractDataset):
    def __init__(self, *args: Any) -> None: ...
    def columnContainsNulls(self, col: int) -> bool: ...
    def datasetContainsNulls(self) -> bool: ...
    def getData(self) -> List[Object]: ...
    def setAllDirectly(
        self, columnNames: List[AnyStr], columnTypes: List[Class], data: Any
    ) -> None: ...
    def setDataDirectly(self, arg: Any) -> None: ...
    def setFromXML(
        self,
        columnNames: List[AnyStr],
        columnTypes: List[Class],
        encodedData: AnyStr,
        rowCount: int,
    ) -> None: ...
    def setValueAt(self, row: int, col: int, value: Any) -> None: ...

class JsonPath(Object):
    ROOT: JsonPath
    def createChildPath(self, arg: Union[JsonPath, int, AnyStr]) -> JsonPath: ...
    def getAsLinkedList(self) -> Any: ...
    def getDepth(self) -> int: ...
    def getKey(self) -> Object: ...
    def getParent(self) -> JsonPath: ...
    def getPathElements(self) -> List[JsonPath]: ...
    def getSubPath(self, startingDepth: int) -> JsonPath: ...
    def isAncestorOf(self, element: JsonPath) -> bool: ...
    def isRelatedTo(self, other: JsonPath) -> bool: ...
    def isRoot(self) -> bool: ...
    @staticmethod
    def isValidIdentifier(test: AnyStr) -> bool: ...
    @staticmethod
    def parse(path: AnyStr) -> AnyStr: ...

class Path:
    SERIALIZATION_WHITELIST: Set[Class]
    def getLastPathComponent(self) -> AnyStr: ...
    def getParentPath(self) -> Path: ...
    def getPathComponent(self, i: int) -> AnyStr: ...
    def getPathLength(self) -> int: ...
    def isAncestorOf(self, path: Path) -> bool: ...

class QualifiedPath(Object):
    def __init__(self) -> None: ...

class StringPath(Object, Path, Comparable):
    PATH_RELATIVE: AnyStr
    PATH_RELATIVE_UP: AnyStr
    PATH_SEPARATOR: AnyStr
    ROOT: StringPath
    def __init__(self, *parts: AnyStr) -> None: ...
    def caseSensitive(self) -> StringPath.CaseSensitiveStringPath: ...
    def compareTo(self, o: Any) -> int: ...
    @staticmethod
    def extend(parent: StringPath, *args: Any) -> StringPath: ...
    def getChildPath(self, *pathParts: AnyStr) -> StringPath: ...
    def getLastPathComponent(self) -> AnyStr: ...
    def getParentPath(self) -> StringPath: ...
    def getParts(self) -> Iterable[AnyStr]: ...
    def getPathComponent(self, i: int) -> AnyStr: ...
    def getPathLength(self) -> int: ...
    def isAncestorOf(self, path: Path) -> bool: ...
    @staticmethod
    def isRelative(path: StringPath) -> bool: ...
    def isRoot(self) -> bool: ...
    @staticmethod
    def makeRelative(toRelative: StringPath, root: StringPath) -> StringPath: ...
    @staticmethod
    def of(*parts: AnyStr) -> StringPath: ...
    @staticmethod
    def removeRelative(relative: StringPath, root: StringPath) -> StringPath: ...
    def subPath(
        self, start: Optional[int] = ..., length: Optional[int] = ...
    ) -> StringPath: ...

    class CaseSensitiveStringPath(Object, Comparable):
        def compareTo(self, o: Any) -> int: ...
        def isAncestorOf(self, child: Path) -> bool: ...

class TypeUtilities(Object):
    DATE_FORMAT_STRING: AnyStr
    NULL_SAFE_CASE_INSENSITIVE_ORDER: Comparator
    def __init__(self) -> None: ...
    @staticmethod
    def anyEqual(value: Any, *args: Any) -> bool: ...
    @staticmethod
    def coerce(value: Object, destType: Class) -> Object: ...
    @staticmethod
    def coerceForLocale(
        value: Object, target: Class, valueLocale: Locale
    ) -> Object: ...
    @staticmethod
    def coerceGeneric(value: Object, destType: Class) -> Any: ...
    @staticmethod
    def coerceLocaleSafe(str: AnyStr, type: Class) -> Object: ...
    @staticmethod
    def coerceNullSafe(value: Object, destType: Class) -> Object: ...
    @staticmethod
    def coerceNumberForLocale(
        value: Object, destType: Class, locale: Locale
    ) -> Object: ...
    @staticmethod
    def coerceNumberNullSafe(
        value: Object, destType: Class, locale: Locale
    ) -> Object: ...
    @staticmethod
    def colorToHex(c: Color) -> AnyStr: ...
    @staticmethod
    def compareInts(foo: int, bar: int) -> int: ...
    @staticmethod
    def compareNullHigh(c1: Any, c2: Any) -> Any: ...
    @staticmethod
    def compareNullLow(c1: Any, c2: Any) -> Any: ...
    @staticmethod
    def datasetFromJSON(json: JSONObject) -> Dataset: ...
    @staticmethod
    def datasetFromJsonString(jsonStr: AnyStr) -> Dataset: ...
    @staticmethod
    def datasetToGson(data: Dataset, gson: Optional[Gson] = ...) -> JsonElement: ...
    @staticmethod
    def datasetToJSON(data: Dataset) -> JSONObject: ...
    @staticmethod
    def deepEquals(o1: Object, o2: Object, checkArrayTypes: bool) -> bool: ...
    @staticmethod
    def equalsIgnoreCase(o1: Object, o2: Object) -> bool: ...
    @staticmethod
    def fromString(value: AnyStr, dest: Class, locale: Locale) -> Object: ...
    @staticmethod
    def getColorFromString(color: AnyStr) -> Color: ...
    @staticmethod
    def getFirstOrNull(list_: List[Any]) -> Any: ...
    @staticmethod
    def getInitValueForClass(c: Class) -> Object: ...
    @staticmethod
    def getLastNameComponent(name: AnyStr) -> AnyStr: ...
    @staticmethod
    def getPrimitiveType(c: Class) -> Object: ...
    @staticmethod
    def getWrapperType(c: Class) -> Class: ...
    @staticmethod
    def gsonToPy(element: JsonElement) -> PyObject: ...
    @staticmethod
    def hasPrimitiveType(c: Class) -> bool: ...
    @staticmethod
    def hasValueChanged(
        currentValue: Any, previousValue: Any, expectedType: Any, deadband: float
    ) -> bool: ...
    @staticmethod
    def isAssignable(dest: Class, source: Class) -> bool: ...
    @staticmethod
    def isBoolean(clazz: Class) -> bool: ...
    @staticmethod
    def isDirectlyAssignable(dest: Class, source: Class) -> bool: ...
    @staticmethod
    def isFractional(clazz: Class) -> bool: ...
    @staticmethod
    def isNullOrEmpty(s: AnyStr) -> bool: ...
    @staticmethod
    def isNumber(clazz: Class) -> bool: ...
    @staticmethod
    def isPrimitive(clazz: Class) -> bool: ...
    @staticmethod
    def isProperNumber(clazz: Class) -> bool: ...
    @staticmethod
    def neq(o1: Object, o2: Object) -> bool: ...
    @staticmethod
    def pyToGson(
        pyObject: PyObject, customGson: Optional[Gson] = ...
    ) -> JsonElement: ...
    @staticmethod
    def pyToJava(pyObject: PyObject) -> Object: ...
    @staticmethod
    def setArrayValue(arrayValue: Object, newVal: Object, pos: int) -> Any: ...
    @staticmethod
    def setClassInitializer(init: TypeUtilities.ClassInitializer) -> None: ...
    @staticmethod
    def toBool(value: Object) -> bool: ...
    @staticmethod
    def toByteArray(uuid: UUID) -> bytearray: ...
    @staticmethod
    def toColor(color: Object) -> Color: ...
    @staticmethod
    def toDataset(value: Object) -> Dataset: ...
    @staticmethod
    def toDate(value: Object) -> Date: ...
    @staticmethod
    def toDocument(value: Object) -> DocumentElement: ...
    @staticmethod
    def toDouble(value: Object) -> float: ...
    @staticmethod
    def toEnum(enumType: Class, value: AnyStr) -> Any: ...
    @staticmethod
    def toFloat(value: Object) -> float: ...
    @staticmethod
    def toInteger(value: Object) -> int: ...
    @staticmethod
    def toLong(value: Object) -> long: ...
    @staticmethod
    def toNumber(value: Object, locale: Optional[Locale] = ...) -> Number: ...
    @staticmethod
    def toShort(value: Object) -> int: ...
    @staticmethod
    def toStr(value: Object) -> AnyStr: ...
    @staticmethod
    def toStringLocalized(value: Object, locale: Optional[Locale] = ...) -> AnyStr: ...
    @staticmethod
    def toStringOnlyNumberLocalized(value: Object, locale: Locale) -> AnyStr: ...
    @staticmethod
    def toUUID(barr: bytearray) -> UUID: ...

    class ClassInitializer:
        def createNew(self, claz: Class) -> Object: ...
