from typing import Any, List

from com.google.common.eventbus import EventBus
from com.inductiveautomation.ignition.client.launch import LaunchContext
from com.inductiveautomation.ignition.client.util.gui.progress import (
    ClientProgressManager,
)
from com.inductiveautomation.ignition.common.db.namedquery import NamedQueryManager
from com.inductiveautomation.ignition.common.execution import ExecutionManager
from com.inductiveautomation.ignition.common.expressions import FunctionFactory
from com.inductiveautomation.ignition.common.i18n.translation import TranslationMap
from com.inductiveautomation.ignition.common.licensing import LicenseState
from com.inductiveautomation.ignition.common.logging import LogFilterSettings
from com.inductiveautomation.ignition.common.model import CommonContext, EdgeEdition
from com.inductiveautomation.ignition.common.modules import ModuleInfo
from com.inductiveautomation.ignition.common.project import Project
from com.inductiveautomation.ignition.common.script import ScriptManager
from com.inductiveautomation.ignition.common.tags.model import TagManager
from com.inductiveautomation.ignition.common.xmlserialization.deserialization import (
    XMLDeserializer,
)
from dev.coatl.helper.types import AnyStr
from java.beans import PropertyChangeListener
from java.lang import Object
from java.util import Locale
from javax.swing import RootPaneContainer
from org.apache.log4j import Logger

class ClientContext(CommonContext):
    def addPropertyChangeListener(self, *args: Any) -> None: ...
    def createDeserializer(self) -> XMLDeserializer: ...
    def desearilize(self, data: bytearray, log: Logger) -> Object: ...
    def getAuthProfileName(self) -> AnyStr: ...
    def getDefaultDataSourceName(self) -> AnyStr: ...
    def getDefaultTagProviderName(self) -> AnyStr: ...
    def getEdgeEditions(self) -> List[EdgeEdition]: ...
    def getEventBus(self) -> EventBus: ...
    def getExecutionManager(self) -> ExecutionManager: ...
    def getExpressionFunctionFactory(self) -> FunctionFactory: ...
    def getLaunchContext(self) -> LaunchContext: ...
    def getLicenseState(self, moduleId: AnyStr) -> LicenseState: ...
    def getLocalizationManager(self) -> ClientLocalizationManager: ...
    def getLoggingManager(self) -> LogFilterSettings: ...
    def getModule(self, id_: AnyStr) -> Object: ...
    def getModules(self) -> List[ModuleInfo]: ...
    def getNamedQueryManager(self) -> NamedQueryManager: ...
    def getProgressManager(self) -> ClientProgressManager: ...
    def getProject(self) -> Project: ...
    def getProjectName(self) -> AnyStr: ...
    def getRootPaneContainer(self) -> RootPaneContainer: ...
    def getScriptManager(self) -> ScriptManager: ...
    def getTagManager(self) -> TagManager: ...
    def getTagPollRate(self) -> int: ...
    def getUIEventBus(self) -> EventBus: ...
    def removePropertyChangeListened(self, *args: Any) -> None: ...

class DesktopListener: ...

class LocaleListener:
    def localeChanged(self, newLocale: Locale) -> None: ...

class ClientLocalizationManager(Object):
    def addLocaleListener(self, listener: LocaleListener) -> None: ...
    def addPropertyChangeListener(
        self, propertyName: AnyStr, listener: PropertyChangeListener
    ) -> None: ...
    def get(self, locale: Locale, key: AnyStr) -> AnyStr: ...
    def getAvailableLocales(self) -> List[Locale]: ...
    def getCurrentLocale(self) -> Locale: ...
    def getPreviewLocale(self) -> Locale: ...
    def getStrict(self, *args: Any) -> AnyStr: ...
    def getString(self, key: AnyStr) -> AnyStr: ...
    def getStringForBundleKey(self, bundlekey: AnyStr) -> AnyStr: ...
    def getTranslationsFor(self, key: AnyStr) -> TranslationMap: ...
    def isTranslationEnabled(self) -> bool: ...
    def removeLocaleListener(self, listener: LocaleListener) -> None: ...
    def removePropertyChangeListener(
        self, propertyName: AnyStr, listener: PropertyChangeListener
    ) -> None: ...
    def resetLocale(self) -> None: ...
    def setCurrentLocale(self, locale: Locale) -> None: ...
