from typing import Any, Dict, List, Optional, Tuple, Union

from com.inductiveautomation.factorypmi.application import FPMIApp, FPMIWindow
from com.inductiveautomation.factorypmi.application.script import PyComponentWrapper
from com.inductiveautomation.ignition.common.model.values import QualityCode
from dev.coatl.helper.types import AnyStr
from java.awt import Color, Component, Graphics
from java.awt.event import ActionEvent, ComponentEvent, MouseEvent
from java.awt.image import BufferedImage
from java.awt.print import PageFormat
from java.lang import Number, Object
from java.util import EventObject
from javax.swing import JComponent, JFrame, JPopupMenu
from org.python.core import PyObject, PySequence, PyTuple

class INavUtilities:
    def centerWindow(self, arg: Union[FPMIWindow, AnyStr]) -> None: ...
    def closeParentWindow(self, event: EventObject) -> None: ...
    def closeWindow(self, arg: Union[FPMIWindow, AnyStr]) -> None: ...
    def getCurrentWindow(self) -> AnyStr: ...
    def goBack(self) -> PyObject: ...
    def goForward(self) -> PyObject: ...
    def goHome(self) -> PyObject: ...
    def openWindow(
        self, path: AnyStr, params: Optional[Dict[AnyStr, Any]] = ...
    ) -> PyObject: ...
    def openWindowImpl(
        self, path: AnyStr, params: Dict[AnyStr, Any], openAdditional: bool
    ) -> PyObject: ...
    def openWindowInstance(
        self, path: AnyStr, params: Optional[Dict[AnyStr, Any]] = ...
    ) -> PyObject: ...
    def swapTo(self, name: AnyStr, params: Dict[AnyStr, Any]) -> PyObject: ...
    def swapWindow(self, *args: Any) -> PyObject: ...

class ClientDatasetUtilities(Object):
    def __init__(self, app: FPMIApp) -> None: ...

class ClientSystemUtilities(Object):
    def __init__(self) -> None: ...

class NavUtilities(INavUtilities):
    def centerWindow(self, arg: Union[FPMIWindow, AnyStr]) -> None: ...
    def closeParentWindow(self, event: EventObject) -> None: ...
    def closeWindow(self, arg: Union[FPMIWindow, AnyStr]) -> None: ...
    def getCurrentWindow(self) -> AnyStr: ...
    def goBack(self) -> PyObject: ...
    def goForward(self) -> PyObject: ...
    def goHome(self) -> PyObject: ...
    def openWindow(
        self, path: AnyStr, params: Optional[Dict[AnyStr, Any]] = ...
    ) -> PyObject: ...
    def openWindowImpl(
        self, path: AnyStr, params: Dict[AnyStr, Any], openAdditional: bool
    ) -> PyObject: ...
    def openWindowInstance(
        self, path: AnyStr, params: Optional[Dict[AnyStr, Any]] = ...
    ) -> PyObject: ...
    def swapTo(self, name: AnyStr, params: Dict[AnyStr, Any]) -> PyObject: ...
    def swapWindow(self, *args: Any) -> PyObject: ...

class PrintUtilities(Object):
    def __init__(self, app: Any) -> None: ...
    def createImage(self, c: Component) -> BufferedImage: ...
    def createPrintJob(self, c: Component) -> PrintUtilities.JythonPrintJob: ...
    def printToImage(self, c: Component, fileName: Optional[str] = ...) -> None: ...

    class ComponentPrinter(Object):
        def __init__(self, c: Component, fit: bool, zoom: float) -> None: ...
        def print(self, g: Graphics, pageFormat: PageFormat, pageIndex: int) -> int: ...

    class JythonPrintJob(Object):
        def __init__(self, c: Component) -> None: ...
        def getBottomMargin(self) -> float: ...
        def getLeftMargin(self) -> float: ...
        def getOrientation(self) -> int: ...
        def getPageHeight(self) -> float: ...
        def getPageWidth(self) -> float: ...
        def getPrinterName(self) -> AnyStr: ...
        def getRightMargin(self) -> float: ...
        def getTopMargin(self) -> float: ...
        def getZoomFactor(self) -> float: ...
        def isFitToPage(self) -> bool: ...
        def isShowPrintDialog(self) -> bool: ...
        def setBottomMargin(self, bottomMargin: float) -> None: ...
        def setFitToPage(self, fitToPage: bool) -> None: ...
        def setLeftMargin(self, leftMargin: float) -> None: ...
        def setMargins(self, m: float) -> None: ...
        def setOrientation(self, orientation: int) -> None: ...
        def setPageHeight(self, pageHeight: float) -> None: ...
        def setPageWidth(self, pageWidth: float) -> None: ...
        def setPrinterName(self, printerName: AnyStr) -> None: ...
        def setRightMargin(self, rightMargin: float) -> None: ...
        def setShowPrintDialog(self, showPrintDialog: bool) -> None: ...
        def setZoomFactor(self, zoomFactor: float) -> None: ...

class WindowUtilities(Object):
    ACCL_NONE: int
    ACCL_CONSTANT: int
    ACCL_FAST_TO_SLOW: int
    ACCL_SLOW_TO_FAST: int
    ACCL_EASE: int
    COORD_DESIGNER: int
    COORD_SCREEN: int
    def chooseColor(
        self, initialColor: Color, dialogTitle: Optional[AnyStr] = ...
    ) -> Color: ...
    def closeDesktop(self, handle: AnyStr) -> None: ...
    @staticmethod
    def color(*args: Any) -> Color: ...
    def confirm(
        self, message: AnyStr, title: AnyStr = ..., allowCancel: bool = ...
    ) -> Optional[bool]: ...
    @staticmethod
    def convertPointToScreen(x: int, y: int, event: EventObject) -> Tuple[int, int]: ...
    @staticmethod
    def createPopupContext() -> WindowUtilities.PopupContext: ...
    @staticmethod
    def createPopupMenu(key: PySequence, functions: PySequence) -> JPopupMenu: ...
    def desktop(self, arg: Union[int, AnyStr]) -> WindowUtilities: ...
    def errorBox(self, message: AnyStr, title: Optional[AnyStr] = ...) -> None: ...
    @staticmethod
    def find(component: JComponent) -> WindowUtilities: ...
    def findWindow(self, path: AnyStr) -> List[PyComponentWrapper]: ...
    def getCurrentDesktop(self) -> AnyStr: ...
    def getDesktopHandles(self) -> PySequence: ...
    def getOpenedWindowNames(self) -> PyTuple: ...
    def getOpenedWindows(self) -> PyTuple: ...
    @staticmethod
    def getParentWindow(event: EventObject) -> PyObject: ...
    def getQuality(self, comp: JComponent, propertyName: AnyStr) -> QualityCode: ...
    def getScreenIndex(self) -> int: ...
    @staticmethod
    def getScreens() -> PySequence: ...
    @staticmethod
    def getSibling(event: EventObject, name: AnyStr) -> PyObject: ...
    def getWindow(self, name: AnyStr) -> PyObject: ...
    def getWindowNames(self) -> PyTuple: ...
    def inputBox(
        self, message: AnyStr, defaultTxt: AnyStr = ...
    ) -> Optional[AnyStr]: ...
    def isTouchscreenModeEnabled(self) -> bool: ...
    def messageBox(self, message: AnyStr, title: AnyStr = ...) -> None: ...
    def openDesktop(self, *args: PyObject, **kwargs: AnyStr) -> JFrame: ...
    def openDiagnostics(self) -> None: ...
    def passwordBox(
        self, message: AnyStr, title: AnyStr = ..., echoChar: AnyStr = ...
    ) -> Optional[AnyStr]: ...
    def setTouchScreenModeEnabled(self, b: bool) -> None: ...
    def showNumericKeyPad(
        self,
        initialValue: Number,
        fontSize: Optional[int] = ...,
        usePasswordMode: bool = ...,
    ) -> Number: ...
    def showTouchscreenKeyboard(
        self,
        initialText: AnyStr,
        fontSize: Optional[int] = ...,
        password: Optional[bool] = ...,
    ) -> AnyStr: ...
    def transform(self, *args: PyObject, **kwargs: AnyStr) -> PyObject: ...
    def warningBox(self, message: AnyStr, title: AnyStr = ...) -> None: ...

    class JyPopupMenu(JPopupMenu):
        def actionPerformed(self, e: ActionEvent) -> None: ...
        def addJyFunction(self, name: AnyStr, fun: PyObject) -> None: ...
        def show(self, me: Union[ComponentEvent, MouseEvent], *args: int) -> None: ...

    class PopupContext(Object):
        def endPopup(self) -> None: ...
        def startPopup(self) -> None: ...
