from typing import Any, List, Union

from com.inductiveautomation.factorypmi.application.components import BasicContainer
from com.inductiveautomation.ignition.client.model import ClientContext, DesktopListener
from com.inductiveautomation.ignition.common.project.resource import ResourcePath
from com.inductiveautomation.ignition.common.script import ScriptManager
from dev.coatl.helper.types import AnyStr
from java.util import TimeZone
from javax.swing import JDesktopPane, JInternalFrame

class VisionDesktop(JDesktopPane):
    PRIMARY_DESKTOP_HANDLE: str
    def __init__(self, clientContext: ClientContext, handle: AnyStr = ...) -> None: ...
    def addDesktopListener(self, arg: DesktopListener) -> None: ...
    def getAdapterContext(self) -> Any: ...
    def getHandle(self) -> AnyStr: ...
    def getOpenedWindows(self) -> List[FPMIWindow]: ...
    def getPath(self, window: FPMIWindow) -> AnyStr: ...
    def getScriptManager(self) -> ScriptManager: ...
    def getWindow(self, arg: Union[AnyStr, ResourcePath]) -> FPMIWindow: ...

class FPMIApp(VisionDesktop):
    TIMEZONE_CLIENT: str
    TIMEZONE_GATEWAY: str
    def getDefaultTimeZone(self) -> AnyStr: ...
    def getLastActivity(self) -> long: ...
    def shutdownDesigner(self) -> None: ...
    def startupDesigner(self, gatewayTimeZone: TimeZone) -> None: ...

class FPMIWindow(JInternalFrame):
    CACHE_ALWAYS: int
    CACHE_AUTO: int
    CACHE_NEVER: int
    DOCK_EAST: int
    DOCK_FLOAT: int
    DOCK_NORTH: int
    DOCK_SOUTH: int
    DOCK_WEST: int
    PARENT_WINDOW_NAME: str
    SHOW_ALWAYS: int
    SHOW_NEVER: int
    SHOW_MAXIMIZED: int
    name: AnyStr
    def __init__(self, name: AnyStr) -> None: ...
    def getPath(self) -> AnyStr: ...
    def getRootContainer(self) -> BasicContainer: ...
