from typing import Any, Iterable, Optional

from java.lang import Object
from java.util import AbstractCollection, Comparator
from java.util.stream import Collector

class ImmutableCollection(AbstractCollection):
    def asList(self) -> ImmutableList: ...
    def contains(self, o: Object) -> bool: ...

    class Builder(Object):
        def add(self, *elements: Any) -> ImmutableCollection.Builder: ...
        def addAll(self, elements: Any) -> ImmutableCollection.Builder: ...
        def build(self) -> ImmutableCollection: ...

class ImmutableList(ImmutableCollection):
    @staticmethod
    def builder() -> ImmutableList.Builder: ...
    @staticmethod
    def builderWithExpectedSize() -> ImmutableList.Builder: ...
    def contains(self, o: Object) -> bool: ...
    @staticmethod
    def copyOf(*args: Any) -> ImmutableList: ...
    def indexOf(self, obj: Object) -> int: ...
    def lastIndexOf(self, obj: Object) -> int: ...
    def listIterator(self, index: Optional[int] = ...) -> UnmodifiableListIterator: ...
    @staticmethod
    def of(*args: Any) -> ImmutableList: ...
    @staticmethod
    def sortedCopyOf(
        comparator: Comparator, elements: Iterable[Any]
    ) -> ImmutableList: ...
    def subList(self, fromIndex: int, toIndex: int) -> ImmutableList: ...
    @staticmethod
    def toImmutableList() -> Collector: ...

    class Builder(ImmutableCollection.Builder):
        def build(self) -> ImmutableList: ...

class ImmutableSet(ImmutableCollection):
    @staticmethod
    def builder() -> ImmutableSet.Builder: ...
    @staticmethod
    def builderWithExpectedSize() -> ImmutableSet.Builder: ...
    def contains(self, o: Object) -> bool: ...
    @staticmethod
    def copyOf(*args: Any) -> ImmutableSet: ...
    @staticmethod
    def of(*args: Any) -> ImmutableSet: ...
    @staticmethod
    def toImmutableSet() -> Collector: ...

    class Builder(ImmutableCollection.Builder):
        def __init__(self) -> None: ...
        def build(self) -> ImmutableSet: ...

class UnmodifiableIterator(Object):
    def remove(self) -> None: ...

class UnmodifiableListIterator(UnmodifiableIterator):
    def add(self, e: Any) -> None: ...
    def set(self, e: Any) -> None: ...
