#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['scanpy',
 'scanpy._utils',
 'scanpy.datasets',
 'scanpy.external',
 'scanpy.external.pp',
 'scanpy.external.tl',
 'scanpy.get',
 'scanpy.metrics',
 'scanpy.neighbors',
 'scanpy.plotting',
 'scanpy.plotting._tools',
 'scanpy.preprocessing',
 'scanpy.preprocessing._deprecated',
 'scanpy.queries',
 'scanpy.sim_models',
 'scanpy.tools']

package_data = \
{'': ['*'],
 'scanpy': ['tests/*',
            'tests/_data/*',
            'tests/_data/10x-10k-subset.zarr/*',
            'tests/_data/10x-10k-subset.zarr/X/*',
            'tests/_data/10x-10k-subset.zarr/obs/*',
            'tests/_data/10x-10k-subset.zarr/var/*',
            'tests/_data/10x_data/*',
            'tests/_data/10x_data/1.2.0/*',
            'tests/_data/10x_data/1.2.0/filtered_gene_bc_matrices/*',
            'tests/_data/10x_data/1.2.0/filtered_gene_bc_matrices/hg19_chr21/*',
            'tests/_data/10x_data/3.0.0/*',
            'tests/_data/10x_data/3.0.0/filtered_feature_bc_matrix/*',
            'tests/_data/visium_data/*',
            'tests/_data/visium_data/1.0.0/*',
            'tests/_data/visium_data/1.0.0/spatial/*',
            'tests/_images/*',
            'tests/_images/embedding-missing-values/*',
            'tests/_scripts/*',
            'tests/external/*',
            'tests/notebooks/*',
            'tests/notebooks/_images_paga_paul15_subsampled/*',
            'tests/notebooks/pbmc3k_images/*'],
 'scanpy._utils': ['compute/*']}

install_requires = \
['anndata>=0.7.4',
 'numpy>=1.17.0',
 'matplotlib>=3.1.2',
 'pandas>=0.21',
 'scipy>=1.4',
 'seaborn',
 'h5py>=2.10.0',
 'tables',
 'tqdm',
 'scikit-learn>=0.22',
 'statsmodels>=0.10.0rc2',
 'patsy',
 'networkx>=2.3',
 'natsort',
 'joblib',
 'numba>=0.41.0',
 'umap-learn>=0.3.10',
 'packaging',
 'sinfo']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=0.7'],
 'bbknn': ['bbknn'],
 'dev': ['setuptools_scm', 'pytoml', 'black>=20.8b1', 'docutils'],
 'doc': ['sphinx>=3.2,<4.1.0',
         'sphinx-rtd-theme>=0.3.1',
         'sphinx-autodoc-typehints',
         'scanpydoc==0.7.2',
         'python-igraph'],
 'doc:python_version < "3.8"': ['typing_extensions'],
 'harmony': ['harmonypy'],
 'leiden': ['python-igraph', 'leidenalg'],
 'louvain': ['python-igraph', 'louvain>=0.6,!=0.6.2'],
 'magic': ['magic-impute>=2.0'],
 'rapids': ['cudf>=0.9', 'cuml>=0.9', 'cugraph>=0.9'],
 'scanorama': ['scanorama'],
 'scrublet': ['scrublet'],
 'skmisc': ['scikit-misc>=0.1.3'],
 'test': ['pytest>=4.4',
          'pytest-nunit',
          'dask[array]!=2.17.0',
          'fsspec',
          'zappy',
          'zarr',
          'profimp',
          'flit_core']}

entry_points = \
{'console_scripts': ['scanpy = scanpy.cli:console_main']}

setup(name='scanpy',
      version='1.8.2',
      description='Single-Cell Analysis in Python.',
      author='Alex Wolf, Philipp Angerer, Fidel Ramirez, Isaac Virshup, Sergei Rybakov, Gokcen Eraslan, Tom White, Malte Luecken, Davide Cittaro, Tobias Callies, Marius Lange, Andrés R. Muñoz-Rojas',
      author_email='f.alex.wolf@gmx.de, philipp.angerer@helmholtz-muenchen.de',
      url='http://github.com/theislab/scanpy',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.7',
     )
