# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hsf', 'hsf.conf']

package_data = \
{'': ['*'],
 'hsf.conf': ['augmentation/*',
              'files/*',
              'hardware/*',
              'hydra/help/*',
              'roiloc/*',
              'segmentation/*']}

install_requires = \
['antspyx>=0.2.9,<0.3.0',
 'deepsparse>=0.8.0,<0.9.0',
 'hydra-core>=1.1.1,<2.0.0',
 'onnxruntime>=1.8.1,<2.0.0',
 'rich>=10.12.0,<11.0.0',
 'roiloc>=0.2.5,<0.3.0',
 'torchio>=0.18.56,<0.19.0',
 'wget>=3.2,<4.0',
 'xxhash>=2.0.2,<3.0.0']

entry_points = \
{'console_scripts': ['deepsparse_support = '
                     'hsf.engines:print_deepsparse_support',
                     'hsf = hsf.factory:start']}

setup_kwargs = {
    'name': 'hsf',
    'version': '1.0.0',
    'description': 'A simple yet exhaustive segmentation tool of the Hippocampal Subfields in T1w and T2w MRIs.',
    'long_description': '======================================\nHippocampal Segmentation Factory (HSF)\n======================================\n\nExhaustive documentation available at: `hsf.rtfd.io <https://hsf.rtfd.io/>`_\n\n**Current Models version:** 2.0.0\n\n.. list-table::\n    :header-rows: 1\n\n    * - Python Package\n      - Code Quality\n      - Misc\n    * - .. image:: https://github.com/clementpoiret/HSF/actions/workflows/python-app.yml/badge.svg?branch=master\n        .. image:: https://badge.fury.io/py/hsf.svg\n           :target: https://badge.fury.io/py/hsf\n        .. image:: https://img.shields.io/pypi/dm/hsf\n           :alt: PyPI - Downloads\n      - .. image:: https://app.codacy.com/project/badge/Grade/cf02d1f84739401ba695e24f333c23b7\n           :target: https://www.codacy.com/gh/clementpoiret/HSF/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=clementpoiret/HSF&amp;utm_campaign=Badge_Grade\n        .. image:: https://app.codacy.com/project/badge/Coverage/cf02d1f84739401ba695e24f333c23b7\n           :target: https://www.codacy.com/gh/clementpoiret/HSF/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=clementpoiret/HSF&amp;utm_campaign=Badge_Grade\n        .. image:: https://api.codeclimate.com/v1/badges/e0bf481dcbf3eecebefd/maintainability\n           :target: https://codeclimate.com/github/clementpoiret/HSF/maintainability\n           :alt: Maintainability\n      - .. image:: https://readthedocs.org/projects/hsf/badge/?version=latest\n           :target: https://hsf.readthedocs.io/en/latest/?badge=latest\n           :alt: Documentation Status\n        .. image:: https://zenodo.org/badge/DOI/10.5281/zenodo.5527122.svg\n           :target: https://doi.org/10.5281/zenodo.5527122\n\n\nThe Hippocampal Segmentation Factory (HSF) is a Python package for\nthe segmentation of the hippocampal subfields in raw MRI volumes.\n\n.. image:: https://raw.githubusercontent.com/clementpoiret/HSF/master/docs/resources/header.svg\n\nThe main idea is to have a one-liner tool that allows the user to\nsegment the hippocampal subfields in a given raw image (T1w or T2w), while keeping\nas much modularity and customization options as possible.\n\nHSF will be able to segment the following subfields:\n\n- Dentate gyrus (DG),\n- Cornu Ammonis (CA1, CA2 & CA3) in a flexible way (e.g. you can ask to combine CA2 and CA3),\n- Subiculum (SUB).\n\nHSF will segment the hippocampus from head to tail: it will produce\nan homogeneous segmentation from the anterior hippocampus (head), to\nthe posterior hippocampus (tail), without assigning a specific head\nor tail class.\n\nHSF results from a collaborative effort:\n\n1. We are continuously working on improving the segmentation of the subfields,\n   mainly by adding new manually segmented MRIs (feel free to send us yours if you can, thanks!)\n2. HSF proposes a "Model Hub", meaning that anyone can distribute their own ONNX segmentation\n   model. Just send us a small `*.yaml` config file, and the end-user will effortlessly be able to\n   use HSF with your model.\n\nPlease note that the tool is still under development and is not yet\nready for production use. It uses multiple expert deep learning models\ntrained on 700+ manually segmented hippocampi which are not yet fully polished.\n\nHSF uses inference sessions provided by `ONNXRuntime <https://onnxruntime.ai>`_,\nwhich means that it can be used *theoretically* on Windows, MacOS and Linux,\nand the following hardware accelerations: CPU, CUDA, DirectML, OneDNN,\nOpenVINO, TensorRT, NUPHAR, Vitis AI, ACL, ArmNN, MIGraphX, and Rockchip NPU.\nPlease be aware that we do not tested all possible configurations, as HSF\nhas been tested only on CPU and CUDA on Linux (Debian-based and Arch-based distros).\n\nSince v1.0.0, HSF also provides a `DeepSparse backend <https://neuralmagic.com/technology/>`_\nwhich can be used in conjunction with pruned and int8 quantized models\nto deliver a much faster CPU inference speed (see [Hardware Acceleration](user-guide/configuration.md)\nsection).\n\n\nTable of Contents...\n====================\n\n.. contents:: ...To guide you in the challenging world of hippocampal subfields segmentation :)\n\n\nInstallation\n============\n\nTo install the package, first setup an environment suitable for your backend (e.g. `ONNX Runtime <https://onnxruntime.ai>`_).\n\nIf the environment isn\'t properly configured, you might be stuck running inference sessions on CPU, which is not optimal unless you use the DeepSparse backend.\n\nThen, simply run:\n\n``pip install hsf``.\n\n\nQuick start\n===========\n\nOnce installed, HSF can be used simply by running the ``hsf`` command.\n\nFor example, to segment a set of T2w MRIs of 0.3*0.3*1.2, run:\n\n``hsf files.path="~/Dataset/MRIs/" files.pattern="*T2w.nii" roiloc.contrast="t2" roiloc.margin=[10,2,10] segmentation=bagging_accurate segmentation.ca_mode="1/2/3"``\n\nNow, let\'s dive into the details.\n\n``files.path`` and ``files.pattern`` are mandatory parameters.\nThey specify the path to the dataset (or MRI) and the pattern to find the files.\n\nAll parameters starting with ``roiloc.`` are directly linked to our home-made ROI location algorithm.\nYou can find more information about it in the `related GitHub repository <https://github.com/clementpoiret/ROILoc>`_.\n\nTo date, we propose 4 different segmentation algorithms (from the fastest to the most accurate):\n\n- ``single_fast``: a segmentation is performed on the whole volume by only one model,\n- ``single_accurate``: a single model segments the same volume that has been augmented 20 times through TTA,\n- ``bagging_fast``: a bagging ensemble of 5 models is used to segment the volume without TTA,\n- ``bagging_accurate``: a bagging ensemble of 5 models is used to segment the volume with TTA.\n\nFinally, ``segmentation.ca_mode`` is a parameter that allows to combine CA1, CA2 and CA3 subfields.\nIt is particularly useful when you want to segment low-resolution images where it makes no sense to\ndistinguish between CA\'s subfields.\n\n\nConfiguration\n=============\n\nAs HSF is pretty modular, you can easily configure it to your needs thanks to Hydra.\n\nCompose your configuration from those groups (group=option)\n\n* augmentation: default\n* files: default\n* roiloc: default_t2iso\n* segmentation: bagging_accurate, bagging_fast, single_accurate, single_fast\n\nOverride anything in the config (e.g. hsf roiloc.margin=[16,2,16])\n\nYou can also add specific configs absent from the default yaml files\n(e.g. hsf +augmentation.elastic.image_interpolation=sitkBSpline)\n\nFields set with ??? are mandatory.\n\n   files:\n\n   * path: ???\n   * pattern: ???\n   * mask_pattern: ``*mask.nii.gz``\n   * output_dir: hsf_outputs\n\n   roiloc:\n\n   * contrast: t2\n   * roi: hippocampus\n   * bet: false\n   * transform_type: AffineFast\n   * margin: [8, 8, 8]\n   * rightoffset: [0, 0, 0]\n   * leftoffset: [0, 0, 0]\n\n   segmentation:\n\n   * ca_mode: 1/2/3\n   * models_path: ~/.hsf/models\n   * models:\n      *  arunet_bag_0.onnx:\n      *  url: https://zenodo.org/record/5524594/files/arunet_bag0.onnx?download=1\n      *  xxh3_64: d0de65baa81d9382\n      * segmentation:\n         * test_time_augmentation: true\n         * test_time_num_aug: 20\n\n   augmentation:\n\n   * flip:\n      * axes:\n         * LR\n      * flip_probability: 0.5\n      * affine_probability: 0.75\n      * affine:\n         * scales: 0.2\n         * degrees: 15\n         * translation: 3\n         * isotropic: false\n      * elastic_probability: 0.25\n      * elastic:\n         * num_control_points: 4\n         * max_displacement: 4\n         * locked_borders: 0\n\n\nChangelogs\n==========\n\nHSF\n---\n\n**Version 1.0.0**\n\n* Added Uncertainty Maps for post-hoc analysis of segmentation results,\n* Support for DeepSparse backend (CPU inference only),\n* Introduced **HSF\'s Model Hub**,\n* Support for batch inference (all backends),\n* Check for updates at startup,\n* Bug fixes and optimizations.\n\n**Version 0.1.2**\n\n* Added build-in support for offsets to recenter the hippocampus in ROILoc,\n* Added support for the customization of Hardware Execution Providers.\n\n**Version 0.1.1**\n\n* Fixed CUDA Execution Provider.\n\n**Version 0.1.0**\n\n* Initial release.\n\n\nModels\n------\n\n**Version 2.0.0**\n\n* Trained with more T1w and T2w MRIs,\n* Trained on more hippocampal sclerosis and Alzheimer\'s disease cases,\n* Updated training pipeline (hyperparameter tuning),\n* `single` models are now independant from bags.\n\n**Version 1.0.0**\n\n* Initial release.\n\n\nDocumentation\n==========================\n\nFor more details about HSF\'s configuration and internal parameters, please refer to\nour `documentation <https://hsf.rtfd.io/>`_.\n\n\nAuthorship, Affiliations and Citations\n======================================\n\nAuthorship:\n\n* C Poiret, UNIACT-NeuroSpin, CEA, Saclay University, France,\n* A Bouyeure, UNIACT-NeuroSpin, CEA, Saclay University, France,\n* S Patil, UNIACT-NeuroSpin, CEA, Saclay University, France,\n* C Boniteau, UNIACT-NeuroSpin, CEA, Saclay University, France,\n* M Noulhiane, UNIACT-NeuroSpin, CEA, Saclay University, France.\n\nIf you use this work, please cite it as follows:\n\n``C. Poiret, et al. (2021). clementpoiret/HSF. Zenodo. https://doi.org/10.5281/zenodo.5527122``\n\nThis work licensed under MIT license was supported in part by the Fondation de France and the IDRIS/GENCI for the HPE Supercomputer Jean Zay.\n',
    'author': 'Clément POIRET',
    'author_email': 'poiret.clement@outlook.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://hippomnesis.dev',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
