/*
 * Copyright 2013 Netherlands eScience Center
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package nl.esciencecenter.amuse.distributed.util;

import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

/**
 * @author Niels Drost
 * 
 */
public class CRC {

    public static int getFunctionID(String name) {
        CRC32 crc = new CRC32();

        crc.update(name.getBytes(StandardCharsets.US_ASCII));

        long result = crc.getValue();

        return Math.abs((int) result);
    }

}
