/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.schedulers;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import nl.esciencecenter.xenon.UnknownAdaptorException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.schedulers.JobStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.SchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.GridEngineSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.local.LocalSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.slurm.SlurmSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.ssh.SshSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.torque.TorqueSchedulerAdaptor;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.credentials.DefaultCredential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import nl.esciencecenter.xenon.schedulers.NoSuchJobException;
import nl.esciencecenter.xenon.schedulers.QueueStatus;
import nl.esciencecenter.xenon.schedulers.SchedulerAdaptorDescription;
import nl.esciencecenter.xenon.schedulers.Streams;

public abstract class Scheduler
implements AutoCloseable {
    private static final String COMPONENT_NAME = "Scheduler";
    private static final HashMap<String, SchedulerAdaptor> adaptors = new LinkedHashMap<String, SchedulerAdaptor>();
    private final String uniqueID;
    private final String adaptor;
    private final String location;
    protected final XenonProperties properties;

    private static void addAdaptor(SchedulerAdaptor adaptor) {
        adaptors.put(adaptor.getName(), adaptor);
    }

    private static SchedulerAdaptor getAdaptorByName(String adaptorName) throws UnknownAdaptorException {
        if (adaptorName == null || adaptorName.trim().isEmpty()) {
            throw new UnknownAdaptorException(COMPONENT_NAME, "Adaptor name may not be null or empty");
        }
        if (!adaptors.containsKey(adaptorName)) {
            throw new UnknownAdaptorException(COMPONENT_NAME, String.format("Adaptor '%s' not found", adaptorName));
        }
        return adaptors.get(adaptorName);
    }

    public static String[] getAdaptorNames() {
        return adaptors.keySet().toArray(new String[adaptors.size()]);
    }

    public static SchedulerAdaptorDescription getAdaptorDescription(String adaptorName) throws UnknownAdaptorException {
        return Scheduler.getAdaptorByName(adaptorName);
    }

    public static SchedulerAdaptorDescription[] getAdaptorDescriptions() {
        return adaptors.values().toArray(new SchedulerAdaptorDescription[adaptors.size()]);
    }

    public static Scheduler create(String adaptor, String location, Credential credential, Map<String, String> properties) throws XenonException {
        return Scheduler.getAdaptorByName(adaptor).createScheduler(location, credential, properties);
    }

    public static Scheduler create(String adaptor, String location, Credential credential) throws XenonException {
        return Scheduler.create(adaptor, location, credential, new HashMap<String, String>(0));
    }

    public static Scheduler create(String adaptor, String location) throws XenonException {
        return Scheduler.create(adaptor, location, new DefaultCredential());
    }

    public static Scheduler create(String adaptor) throws XenonException {
        return Scheduler.create(adaptor, null);
    }

    protected Scheduler(String uniqueID, String adaptor, String location, XenonProperties properties) {
        if (uniqueID == null) {
            throw new IllegalArgumentException("Identifier may not be null!");
        }
        if (adaptor == null) {
            throw new IllegalArgumentException("Adaptor may not be null!");
        }
        if (location == null) {
            throw new IllegalArgumentException("Location may not be null!");
        }
        this.uniqueID = uniqueID;
        this.adaptor = adaptor;
        this.location = location;
        this.properties = properties;
    }

    public String getAdaptorName() {
        return this.adaptor;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, String> getProperties() {
        return this.properties.toMap();
    }

    public abstract String[] getQueueNames() throws XenonException;

    @Override
    public abstract void close() throws XenonException;

    public abstract boolean isOpen() throws XenonException;

    public abstract String getDefaultQueueName() throws XenonException;

    public abstract String[] getJobs(String ... var1) throws XenonException;

    public abstract QueueStatus getQueueStatus(String var1) throws XenonException;

    public abstract QueueStatus[] getQueueStatuses(String ... var1) throws XenonException;

    public abstract String submitBatchJob(JobDescription var1) throws XenonException;

    public abstract Streams submitInteractiveJob(JobDescription var1) throws XenonException;

    public abstract JobStatus getJobStatus(String var1) throws XenonException;

    public JobStatus[] getJobStatuses(String ... jobIdentifiers) throws XenonException {
        JobStatus[] result = new JobStatus[jobIdentifiers.length];
        for (int i = 0; i < jobIdentifiers.length; ++i) {
            try {
                if (jobIdentifiers[i] != null) {
                    result[i] = this.getJobStatus(jobIdentifiers[i]);
                    continue;
                }
                result[i] = null;
                continue;
            }
            catch (NoSuchJobException e) {
                result[i] = new JobStatusImplementation(jobIdentifiers[i], "UNKNOWN", null, e, false, false, null);
                continue;
            }
            catch (XenonException e) {
                result[i] = new JobStatusImplementation(jobIdentifiers[i], "ERROR", null, e, false, false, null);
            }
        }
        return result;
    }

    public abstract JobStatus cancelJob(String var1) throws XenonException;

    public abstract JobStatus waitUntilDone(String var1, long var2) throws XenonException;

    public abstract JobStatus waitUntilRunning(String var1, long var2) throws XenonException;

    public abstract boolean usesFileSystem();

    public abstract FileSystem getFileSystem() throws XenonException;

    protected void assertNonNullOrEmpty(String s, String message) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    protected void assertPositive(long value, String message) {
        if (value < 0L) {
            throw new IllegalArgumentException(message + value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scheduler scheduler = (Scheduler)o;
        return Objects.equals(this.uniqueID, scheduler.uniqueID);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueID);
    }

    static {
        Scheduler.addAdaptor(new LocalSchedulerAdaptor());
        Scheduler.addAdaptor(new SshSchedulerAdaptor());
        Scheduler.addAdaptor(new GridEngineSchedulerAdaptor());
        Scheduler.addAdaptor(new SlurmSchedulerAdaptor());
        Scheduler.addAdaptor(new TorqueSchedulerAdaptor());
    }
}

