/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.gridengine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.esciencecenter.xenon.UnsupportedOperationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.JobCanceledException;
import nl.esciencecenter.xenon.adaptors.schedulers.JobStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.QueueStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.RemoteCommandRunner;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingParser;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingScheduler;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.GridEngineSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.GridEngineSetup;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.GridEngineUtils;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.GridEngineXmlParser;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import nl.esciencecenter.xenon.schedulers.NoSuchJobException;
import nl.esciencecenter.xenon.schedulers.NoSuchQueueException;
import nl.esciencecenter.xenon.schedulers.QueueStatus;
import nl.esciencecenter.xenon.schedulers.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridEngineScheduler
extends ScriptingScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridEngineScheduler.class);
    private final long accountingGraceTime;
    private final Map<String, Long> lastSeenMap;
    private final Set<Long> deletedJobs;
    private final GridEngineXmlParser parser;
    private final GridEngineSetup setupInfo;

    protected GridEngineScheduler(String uniqueID, String location, Credential credential, Map<String, String> prop) throws XenonException {
        super(uniqueID, "gridengine", location, credential, prop, GridEngineSchedulerAdaptor.VALID_PROPERTIES, "xenon.adaptors.schedulers.gridengine.poll.delay");
        boolean ignoreVersion = this.properties.getBooleanProperty("xenon.adaptors.schedulers.gridengine.ignore.version");
        this.accountingGraceTime = this.properties.getLongProperty("xenon.adaptors.schedulers.gridengine.accounting.grace.time");
        this.parser = new GridEngineXmlParser(ignoreVersion);
        this.lastSeenMap = new HashMap<String, Long>();
        this.deletedJobs = new HashSet<Long>();
        this.setupInfo = new GridEngineSetup(this);
    }

    @Override
    public String[] getQueueNames() {
        return this.setupInfo.getQueueNames();
    }

    @Override
    public String getDefaultQueueName() {
        return null;
    }

    private synchronized void updateJobsSeenMap(Set<String> identifiers) {
        long currentTime = System.currentTimeMillis();
        for (String identifier : identifiers) {
            this.lastSeenMap.put(identifier, currentTime);
        }
        long expiredTime = currentTime + this.accountingGraceTime;
        Iterator<Map.Entry<String, Long>> iterator = this.lastSeenMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (entry.getValue() <= expiredTime) continue;
            iterator.remove();
        }
    }

    private synchronized boolean haveRecentlySeen(String identifier) {
        if (!this.lastSeenMap.containsKey(identifier)) {
            return false;
        }
        return this.lastSeenMap.get(identifier) + this.accountingGraceTime > System.currentTimeMillis();
    }

    private synchronized void addDeletedJob(String jobIdentifier) {
        this.deletedJobs.add(Long.parseLong(jobIdentifier));
    }

    private synchronized boolean jobWasDeleted(String jobIdentifier) {
        if (this.deletedJobs.isEmpty()) {
            return false;
        }
        return this.deletedJobs.remove(Long.parseLong(jobIdentifier));
    }

    private void jobsFromStatus(String statusOutput, List<String> result) throws XenonException {
        Map<String, Map<String, String>> status = this.parser.parseJobInfos(statusOutput);
        this.updateJobsSeenMap(status.keySet());
        result.addAll(status.keySet());
    }

    @Override
    public String[] getJobs(String ... queueNames) throws XenonException {
        ArrayList<String> result = new ArrayList<String>();
        if (queueNames == null || queueNames.length == 0) {
            String statusOutput = this.runCheckedCommand(null, "qstat", "-xml");
            this.jobsFromStatus(statusOutput, result);
        } else {
            for (String queueName : queueNames) {
                RemoteCommandRunner runner = this.runCommand(null, "qstat", "-xml", "-q", queueName);
                if (!runner.success()) {
                    if (runner.getExitCode() == 1) {
                        LOGGER.warn("Failed to get queue status for queue " + runner);
                        throw new NoSuchQueueException("gridengine", "Failed to get queue status for queue \"" + queueName + "\": " + runner);
                    }
                    throw new XenonException("gridengine", "Failed to get queue status for queue \"" + queueName + "\": " + runner);
                }
                this.jobsFromStatus(runner.getStdout(), result);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public QueueStatus getQueueStatus(String queueName) throws XenonException {
        this.assertNonNullOrEmpty(queueName, "Queue name cannot be null or empty!");
        String qstatOutput = this.runCheckedCommand(null, "qstat", "-xml", "-g", "c");
        Map<String, Map<String, String>> allMap = this.parser.parseQueueInfos(qstatOutput);
        Map<String, String> map = allMap.get(queueName);
        if (map == null || map.isEmpty()) {
            throw new NoSuchQueueException("gridengine", "Cannot get status of queue \"" + queueName + "\" from server, perhaps it does not exist?");
        }
        return new QueueStatusImplementation(this, queueName, null, map);
    }

    @Override
    public QueueStatus[] getQueueStatuses(String ... queueNames) throws XenonException {
        if (queueNames == null) {
            throw new IllegalArgumentException("Queue names cannot be null");
        }
        if (queueNames.length == 0) {
            queueNames = this.getQueueNames();
        }
        String qstatOutput = this.runCheckedCommand(null, "qstat", "-xml", "-g", "c");
        Map<String, Map<String, String>> allMap = this.parser.parseQueueInfos(qstatOutput);
        return this.getQueueStatuses(allMap, queueNames);
    }

    @Override
    public Streams submitInteractiveJob(JobDescription description) throws XenonException {
        throw new UnsupportedOperationException("gridengine", "Interactive jobs not supported");
    }

    @Override
    public String submitBatchJob(JobDescription description) throws XenonException {
        String output;
        Path fsEntryPath = this.getWorkingDirectory();
        GridEngineUtils.verifyJobDescription(description);
        this.checkQueue(this.setupInfo.getQueueNames(), description.getQueueName());
        String customScriptFile = description.getJobOptions().get("job.script");
        if (customScriptFile == null) {
            String jobScript = GridEngineUtils.generate(description, fsEntryPath, this.setupInfo);
            output = this.runCheckedCommand(jobScript, "qsub", new String[0]);
        } else {
            if (!customScriptFile.startsWith("/")) {
                Path scriptFile = fsEntryPath.resolve(customScriptFile);
                customScriptFile = scriptFile.toString();
            }
            output = this.runCheckedCommand(null, "qsub", customScriptFile);
        }
        String identifier = ScriptingParser.parseJobIDFromLine(output, "gridengine", "Your job");
        this.updateJobsSeenMap(Collections.singleton(identifier));
        return identifier;
    }

    @Override
    public JobStatus cancelJob(String jobIdentifier) throws XenonException {
        this.assertNonNullOrEmpty(jobIdentifier, "Job identifier cannot be null or empty");
        String qdelOutput = this.runCheckedCommand(null, "qdel", jobIdentifier);
        String killedOutput = "has registered the job " + jobIdentifier + " for deletion";
        String deletedOutput = "has deleted job " + jobIdentifier;
        int matched = ScriptingParser.checkIfContains(qdelOutput, "gridengine", killedOutput, deletedOutput);
        if (matched == 1) {
            this.addDeletedJob(jobIdentifier);
        } else {
            this.updateJobsSeenMap(Collections.singleton(jobIdentifier));
        }
        return this.getJobStatus(jobIdentifier);
    }

    private Map<String, Map<String, String>> getQstatInfo() throws XenonException {
        RemoteCommandRunner runner = this.runCommand(null, "qstat", "-xml");
        if (!runner.success()) {
            LOGGER.debug("failed to get job status {}", (Object)runner);
            return new HashMap<String, Map<String, String>>(0);
        }
        Map<String, Map<String, String>> result = this.parser.parseJobInfos(runner.getStdout());
        this.updateJobsSeenMap(result.keySet());
        return result;
    }

    private Map<String, String> getQacctInfo(String jobIdentifier) throws XenonException {
        RemoteCommandRunner runner = this.runCommand(null, "qacct", "-j", jobIdentifier);
        if (!runner.success()) {
            LOGGER.debug("failed to get job status {}", (Object)runner);
            return null;
        }
        return ScriptingParser.parseKeyValueLines(runner.getStdout(), ScriptingParser.WHITESPACE_REGEX, "gridengine", "==============================================================");
    }

    private JobStatus getJobStatus(Map<String, Map<String, String>> qstatInfo, String jobIdentifier) throws XenonException {
        if (jobIdentifier == null) {
            return null;
        }
        JobStatus status = GridEngineUtils.getJobStatusFromQstatInfo(qstatInfo, jobIdentifier);
        if (status != null && status.hasException()) {
            this.cancelJob(jobIdentifier);
            status = null;
        }
        if (status == null) {
            Map<String, String> qacctInfo = this.getQacctInfo(jobIdentifier);
            status = GridEngineUtils.getJobStatusFromQacctInfo(qacctInfo, jobIdentifier);
        }
        if (status == null && this.jobWasDeleted(jobIdentifier)) {
            JobCanceledException exception = new JobCanceledException("gridengine", "Job " + jobIdentifier + " deleted by user while still pending");
            status = new JobStatusImplementation(jobIdentifier, "killed", null, exception, false, true, null);
        }
        if (status == null && this.haveRecentlySeen(jobIdentifier)) {
            status = new JobStatusImplementation(jobIdentifier, "unknown", null, null, false, false, new HashMap<String, String>());
        }
        return status;
    }

    @Override
    public JobStatus getJobStatus(String jobIdentifier) throws XenonException {
        this.assertNonNullOrEmpty(jobIdentifier, "Job identifier cannot be null or empty");
        Map<String, Map<String, String>> info = this.getQstatInfo();
        JobStatus result = this.getJobStatus(info, jobIdentifier);
        if (result == null) {
            throw new NoSuchJobException("gridengine", "Job " + jobIdentifier + " not found on server");
        }
        return result;
    }

    @Override
    public JobStatus[] getJobStatuses(String ... jobs) throws XenonException {
        Map<String, Map<String, String>> info = this.getQstatInfo();
        JobStatus[] result = new JobStatus[jobs.length];
        for (int i = 0; i < result.length; ++i) {
            if (jobs[i] == null) {
                result[i] = null;
                continue;
            }
            result[i] = this.getJobStatus(info, jobs[i]);
            if (result[i] != null) continue;
            NoSuchJobException exception = new NoSuchJobException("gridengine", "Job " + jobs[i] + " not found on server");
            result[i] = new JobStatusImplementation(jobs[i], null, null, exception, false, false, null);
        }
        return result;
    }
}

