/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import nl.esciencecenter.xenon.InvalidLocationException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.schedulers.Deadline;
import nl.esciencecenter.xenon.adaptors.schedulers.QueueStatusImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.RemoteCommandRunner;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingUtils;
import nl.esciencecenter.xenon.credentials.Credential;
import nl.esciencecenter.xenon.filesystems.FileSystem;
import nl.esciencecenter.xenon.filesystems.Path;
import nl.esciencecenter.xenon.schedulers.InvalidJobDescriptionException;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.JobStatus;
import nl.esciencecenter.xenon.schedulers.NoSuchQueueException;
import nl.esciencecenter.xenon.schedulers.QueueStatus;
import nl.esciencecenter.xenon.schedulers.Scheduler;
import nl.esciencecenter.xenon.schedulers.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptingScheduler
extends Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingScheduler.class);
    protected final Scheduler subScheduler;
    protected final FileSystem subFileSystem;
    protected final long pollDelay;

    protected ScriptingScheduler(String uniqueID, String adaptor, String location, Credential credential, Map<String, String> prop, XenonPropertyDescription[] validProperties, String pollDelayProperty) throws XenonException {
        super(uniqueID, adaptor, location, ScriptingUtils.getProperties(validProperties, location, prop));
        Map<String, String> subSchedulerProperties;
        String subLocation;
        String subFileSystemAdaptor;
        String subSchedulerAdaptor;
        this.pollDelay = this.properties.getLongProperty(pollDelayProperty);
        if (ScriptingUtils.isLocal(location)) {
            subSchedulerAdaptor = "local";
            subFileSystemAdaptor = "file";
            subLocation = location.startsWith("local://") ? location.substring("local://".length()) : "";
            subSchedulerProperties = this.properties.filter("xenon.adaptors.schedulers.local.").toMap();
        } else if (ScriptingUtils.isSSH(location)) {
            subSchedulerAdaptor = "ssh";
            subFileSystemAdaptor = "sftp";
            subLocation = location.substring("ssh://".length());
            subSchedulerProperties = this.properties.filter("xenon.adaptors.schedulers.ssh.").toMap();
            subSchedulerProperties.put("xenon.adaptors.schedulers.ssh.queue.pollingDelay", "100");
        } else {
            throw new InvalidLocationException(this.getAdaptorName(), "Invalid location: " + location);
        }
        LOGGER.debug("creating sub scheduler for {} adaptor at {}://{}", new Object[]{adaptor, subSchedulerAdaptor, subLocation});
        this.subScheduler = Scheduler.create(subSchedulerAdaptor, subLocation, credential, subSchedulerProperties);
        LOGGER.debug("creating file system for {} adaptor at {}://{}", new Object[]{adaptor, subFileSystemAdaptor, subLocation});
        this.subFileSystem = FileSystem.create(subFileSystemAdaptor, subLocation, credential, null);
    }

    protected Path getWorkingDirectory() {
        return this.subFileSystem.getWorkingDirectory();
    }

    protected QueueStatus[] getQueueStatuses(Map<String, Map<String, String>> all, String ... queueNames) {
        QueueStatus[] result = new QueueStatus[queueNames.length];
        for (int i = 0; i < queueNames.length; ++i) {
            if (queueNames[i] == null) {
                result[i] = null;
                continue;
            }
            Map<String, String> map = all.get(queueNames[i]);
            if (map == null) {
                NoSuchQueueException exception = new NoSuchQueueException(this.getAdaptorName(), "Cannot get status of queue \"" + queueNames[i] + "\" from server, perhaps it does not exist?");
                result[i] = new QueueStatusImplementation(this, queueNames[i], exception, null);
                continue;
            }
            result[i] = new QueueStatusImplementation(this, queueNames[i], null, map);
        }
        return result;
    }

    public RemoteCommandRunner runCommand(String stdin, String executable, String ... arguments) throws XenonException {
        return new RemoteCommandRunner(this.subScheduler, stdin, executable, arguments);
    }

    protected void translateError(RemoteCommandRunner runner, String stdin, String executable, String ... arguments) throws XenonException {
        throw new XenonException(this.getAdaptorName(), "could not run command \"" + executable + "\" with stdin \"" + stdin + "\" arguments \"" + Arrays.toString(arguments) + "\" using scheduler \"" + this.subScheduler.getAdaptorName() + "\". Exit code = " + runner.getExitCode() + " Output: " + runner.getStdout() + " Error output: " + runner.getStderr());
    }

    public String runCheckedCommand(String stdin, String executable, String ... arguments) throws XenonException {
        RemoteCommandRunner runner = new RemoteCommandRunner(this.subScheduler, stdin, executable, arguments);
        if (!runner.success()) {
            this.translateError(runner, stdin, executable, arguments);
        }
        return runner.getStdout();
    }

    public Streams startInteractiveCommand(String executable, String ... arguments) throws XenonException {
        JobDescription description = new JobDescription();
        description.setQueueName("unlimited");
        description.setExecutable(executable);
        description.setArguments(arguments);
        return this.subScheduler.submitInteractiveJob(description);
    }

    protected void checkQueueNames(String[] givenQueueNames) throws XenonException {
        HashSet<String> invalidQueues = new HashSet<String>(Arrays.asList(givenQueueNames));
        invalidQueues.removeAll(Arrays.asList(this.getQueueNames()));
        if (!invalidQueues.isEmpty()) {
            throw new NoSuchQueueException(this.getAdaptorName(), "Invalid queues given: " + Arrays.toString(invalidQueues.toArray(new String[invalidQueues.size()])));
        }
    }

    protected boolean sleep(long pollDelay) {
        try {
            Thread.sleep(pollDelay);
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    @Override
    public JobStatus waitUntilDone(String jobIdentifier, long timeout) throws XenonException {
        this.assertNonNullOrEmpty(jobIdentifier, "Job identifier cannot be null or empty");
        long deadline = Deadline.getDeadline(timeout);
        JobStatus status = this.getJobStatus(jobIdentifier);
        while (!status.isDone() && System.currentTimeMillis() < deadline) {
            if (this.sleep(this.pollDelay)) {
                return status;
            }
            status = this.getJobStatus(jobIdentifier);
        }
        return status;
    }

    @Override
    public JobStatus waitUntilRunning(String jobIdentifier, long timeout) throws XenonException {
        this.assertNonNullOrEmpty(jobIdentifier, "Job identifier cannot be null or empty");
        long deadline = Deadline.getDeadline(timeout);
        JobStatus status = this.getJobStatus(jobIdentifier);
        while (!status.isRunning() && !status.isDone() && System.currentTimeMillis() < deadline) {
            if (this.sleep(this.pollDelay)) {
                return status;
            }
            status = this.getJobStatus(jobIdentifier);
        }
        return status;
    }

    protected void checkQueue(String[] queueNames, String queueName) throws NoSuchQueueException {
        if (queueName == null) {
            return;
        }
        for (String q : queueNames) {
            if (!queueName.equals(q)) continue;
            return;
        }
        throw new NoSuchQueueException("slurm", "Queue does not exist: " + queueName);
    }

    protected void checkWorkingDirectory(String workingDirectory) throws XenonException {
        if (workingDirectory == null) {
            return;
        }
        Path path = workingDirectory.startsWith("/") ? new Path(workingDirectory) : this.getWorkingDirectory().resolve(workingDirectory);
        if (!this.subFileSystem.exists(path)) {
            throw new InvalidJobDescriptionException(this.getAdaptorName(), "Working directory does not exist: " + path);
        }
    }

    @Override
    public boolean isOpen() throws XenonException {
        return this.subScheduler.isOpen() && this.subFileSystem.isOpen();
    }

    @Override
    public void close() throws XenonException {
        this.subScheduler.close();
        this.subFileSystem.close();
    }

    @Override
    public boolean usesFileSystem() {
        return true;
    }

    @Override
    public FileSystem getFileSystem() throws XenonException {
        return this.subFileSystem;
    }
}

