/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.CommandLineUtils;

public final class ScriptingParser {
    public static final Pattern WHITESPACE_REGEX = Pattern.compile("\\s+");
    public static final Pattern BAR_REGEX = Pattern.compile("\\s*\\|\\s*");
    public static final Pattern NEWLINE_REGEX = Pattern.compile("\\r?\\n");
    public static final Pattern EQUALS_REGEX = Pattern.compile("\\s*=\\s*");
    public static final Pattern HORIZONTAL_LINE_REGEX = Pattern.compile("^\\s*([=_-]{3,}\\s*)+$");

    private ScriptingParser() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<String, String> parseKeyValuePairs(String input, String adaptorName, String ... ignoredLines) throws XenonException {
        String[] lines = NEWLINE_REGEX.split(input);
        HashMap<String, String> result = new HashMap<String, String>(lines.length * 4 / 3);
        for (String line : lines) {
            String[] pairs;
            if (line.isEmpty() || ScriptingParser.containsAny(line, ignoredLines)) continue;
            for (String pair : pairs = WHITESPACE_REGEX.split(line.trim())) {
                String[] elements = EQUALS_REGEX.split(pair, 2);
                if (elements.length != 2) {
                    throw new XenonException(adaptorName, "Got invalid key/value pair in output: \"" + pair + "\"");
                }
                result.put(elements[0].trim(), elements[1].trim());
            }
        }
        return result;
    }

    public static boolean containsAny(String input, String ... options) {
        for (String string : options) {
            if (!input.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> parseKeyValueLines(String input, Pattern separatorRegEx, String adaptorName, String ... ignoredLines) throws XenonException {
        String[] lines = NEWLINE_REGEX.split(input);
        HashMap<String, String> result = new HashMap<String, String>(lines.length * 4 / 3);
        for (String line : lines) {
            if (line.isEmpty() || ScriptingParser.containsAny(line, ignoredLines)) continue;
            String[] elements = separatorRegEx.split(line, 2);
            if (elements.length != 2) {
                throw new XenonException(adaptorName, "Got invalid key/value pair in output: " + line);
            }
            result.put(elements[0].trim(), elements[1].trim());
        }
        return result;
    }

    public static String parseJobIDFromLine(String input, String adaptorName, String ... possiblePrefixes) throws XenonException {
        for (String prefix : possiblePrefixes) {
            if (!input.startsWith(prefix)) continue;
            String jobId = input.substring(prefix.length()).trim();
            if ((jobId = jobId.trim()).length() == 0) {
                throw new XenonException(adaptorName, "failed to get jobID from line: \"" + input + "\" Line did not contain job ID.");
            }
            return WHITESPACE_REGEX.split(jobId)[0];
        }
        throw new XenonException(adaptorName, "Failed to get jobID from line: \"" + input + "\" Line does not match expected prefixes: " + Arrays.toString(possiblePrefixes));
    }

    public static String cleanValue(String value, String ... suffixes) {
        String trimmed = value.trim();
        for (String suffix : suffixes) {
            if (!trimmed.endsWith(suffix)) continue;
            return trimmed.substring(0, trimmed.length() - suffix.length());
        }
        return trimmed;
    }

    public static Map<String, Map<String, String>> parseTable(String input, String keyField, Pattern fieldSeparatorRegEx, String adaptorName, String ... valueSuffixes) throws XenonException {
        int headerLine;
        if (input.isEmpty()) {
            throw new XenonException(adaptorName, "Cannot parse table, Got no input, expected at least a header");
        }
        String[] lines = NEWLINE_REGEX.split(input);
        for (headerLine = 0; headerLine < lines.length && HORIZONTAL_LINE_REGEX.matcher(lines[headerLine]).find(); ++headerLine) {
        }
        if (headerLine == lines.length) {
            throw new XenonException(adaptorName, "No table header encountered");
        }
        Object[] fields = fieldSeparatorRegEx.split(lines[headerLine]);
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = fields[i].trim();
            if (!fields[i].isEmpty()) continue;
            throw new XenonException(adaptorName, "Output contains empty field name in line \"" + lines[0] + "\"");
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(lines.length * 4 / 3);
        int rowSize = (int)Math.ceil((double)fields.length / 0.75);
        for (int i = headerLine + 1; i < lines.length; ++i) {
            if (HORIZONTAL_LINE_REGEX.matcher(lines[i]).find()) continue;
            Object[] values = ScriptingParser.mergeTuples(fieldSeparatorRegEx.split(lines[i]));
            if (fields.length != values.length) {
                throw new XenonException(adaptorName, "Expected " + fields.length + " fields in output " + Arrays.toString(fields) + ", got line with " + values.length + " values: " + lines[i] + "parsed to: " + Arrays.toString(values) + " original input\n\n" + input + "\n\n");
            }
            HashMap<Object, String> map = new HashMap<Object, String>(rowSize);
            for (int j = 0; j < fields.length; ++j) {
                map.put(fields[j], ScriptingParser.cleanValue(values[j], valueSuffixes));
            }
            if (!map.containsKey(keyField)) {
                throw new XenonException(adaptorName, "Output does not contain required field \"" + keyField + "\"");
            }
            result.put((String)map.get(keyField), (Map<String, String>)map);
        }
        return result;
    }

    private static String[] mergeTuples(String[] values) {
        boolean inTuple = false;
        ArrayList<String> tmp = new ArrayList<String>();
        String current = null;
        for (String v : values) {
            if (!inTuple) {
                if (v.startsWith("(") && !v.endsWith(")")) {
                    inTuple = true;
                    current = v;
                    continue;
                }
                tmp.add(v);
                continue;
            }
            current = CommandLineUtils.concat(current, " ", v);
            if (!v.endsWith(")") || v.startsWith("(")) continue;
            inTuple = false;
            tmp.add(current);
            current = null;
        }
        if (inTuple) {
            return values;
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    public static int checkIfContains(String input, String adaptorName, String ... options) throws XenonException {
        for (int i = 0; i < options.length; ++i) {
            if (!input.contains(options[i])) continue;
            return i;
        }
        throw new XenonException(adaptorName, "Output does not contain expected string: " + Arrays.toString(options));
    }

    public static String[] parseList(String input) {
        String[] out = WHITESPACE_REGEX.split(input);
        if (out.length == 1 && "".equals(out[0])) {
            return new String[0];
        }
        return out;
    }

    public static Map<String, Map<String, String>> parseKeyValueRecords(String input, String keyField, Pattern separatorRegEx, String adaptorName, String ... ignoredLines) throws XenonException {
        String[] lines = NEWLINE_REGEX.split(input);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap<String, String> currentMap = null;
        for (String line : lines) {
            if (line.isEmpty() || ScriptingParser.containsAny(line, ignoredLines)) continue;
            String[] elements = separatorRegEx.split(line, 2);
            if (elements.length != 2) {
                throw new XenonException(adaptorName, "Expected two columns in output, got \"" + line + "\"");
            }
            String key = elements[0].trim();
            String value = elements[1].trim();
            if (key.equals(keyField)) {
                currentMap = new HashMap<String, String>(2);
                result.put(value, currentMap);
            } else if (currentMap == null) {
                throw new XenonException(adaptorName, "Expecting \"" + keyField + "\" on first line, got \"" + line + "\"");
            }
            currentMap.put(key, value);
        }
        return result;
    }
}

