/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import java.util.Map;
import java.util.Objects;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.schedulers.JobStatus;

public class JobStatusImplementation
implements JobStatus {
    private final String jobIdentifier;
    private final String state;
    private final Integer exitCode;
    private final XenonException exception;
    private final boolean running;
    private final boolean done;
    private final Map<String, String> schedulerSpecificInformation;

    public JobStatusImplementation(String jobIdentifier, String state, Integer exitCode, XenonException exception, boolean running, boolean done, Map<String, String> schedulerSpecificInformation) {
        if (jobIdentifier == null) {
            throw new IllegalArgumentException("Job may not be null!");
        }
        this.jobIdentifier = jobIdentifier;
        this.state = state;
        this.exitCode = exitCode;
        this.exception = exception;
        this.running = running;
        this.done = done;
        this.schedulerSpecificInformation = schedulerSpecificInformation;
    }

    @Override
    public String getJobIdentifier() {
        return this.jobIdentifier;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public XenonException getException() {
        return this.exception;
    }

    @Override
    public void maybeThrowException() throws XenonException {
        if (this.hasException()) {
            throw this.getException();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean hasException() {
        return this.exception != null;
    }

    @Override
    public Map<String, String> getSchedulerSpecificInformation() {
        return this.schedulerSpecificInformation;
    }

    public String toString() {
        return "JobStatus [jobIdentifier=" + this.jobIdentifier + ", state=" + this.state + ", exitCode=" + this.exitCode + ", exception=" + this.exception + ", running=" + this.running + ", done=" + this.done + ", schedulerSpecificInformation=" + this.schedulerSpecificInformation + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobStatusImplementation that = (JobStatusImplementation)o;
        return this.running == that.running && this.done == that.done && Objects.equals(this.jobIdentifier, that.jobIdentifier) && Objects.equals(this.state, that.state) && Objects.equals(this.exitCode, that.exitCode) && Objects.equals(this.exception, that.exception) && Objects.equals(this.schedulerSpecificInformation, that.schedulerSpecificInformation);
    }

    public int hashCode() {
        return Objects.hash(this.jobIdentifier, this.state, this.exitCode, this.exception, this.running, this.done, this.schedulerSpecificInformation);
    }
}

