/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Locality
extends GraphEltSet {
    protected GraphEltSet completeEltSet;

    public Locality(GraphEltSet ges) {
        this.completeEltSet = ges;
    }

    public GraphEltSet getCompleteEltSet() {
        return this.completeEltSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addNode(Node n) throws TGException {
        if (!this.contains(n)) {
            super.addNode(n);
            GraphEltSet graphEltSet = this.completeEltSet;
            synchronized (graphEltSet) {
                if (!this.completeEltSet.contains(n)) {
                    this.completeEltSet.addNode(n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addEdge(Edge e) {
        if (!this.contains(e)) {
            this.edges.add(e);
            GraphEltSet graphEltSet = this.completeEltSet;
            synchronized (graphEltSet) {
                if (!this.completeEltSet.contains(e)) {
                    this.completeEltSet.addEdge(e);
                }
            }
        }
    }

    public synchronized void addNodeWithEdges(Node n) throws TGException {
        this.addNode(n);
        for (Edge e : n.getEdgeIterable()) {
            if (!this.contains(e.getOtherEndpt(n))) continue;
            this.addEdge(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAll() throws TGException {
        GraphEltSet graphEltSet = this.completeEltSet;
        synchronized (graphEltSet) {
            for (Node n : this.completeEltSet.nodes) {
                this.addNode(n);
            }
            for (Edge e : this.completeEltSet.edges) {
                this.addEdge(e);
            }
        }
    }

    @Override
    public Edge findEdge(Node from, Node to) {
        Edge foundEdge = super.findEdge(from, to);
        if (foundEdge != null && this.edges.contains(foundEdge)) {
            return foundEdge;
        }
        return null;
    }

    @Override
    public boolean deleteEdge(Edge e) {
        if (e == null) {
            return false;
        }
        this.removeEdge(e);
        return this.completeEltSet.deleteEdge(e);
    }

    @Override
    public synchronized void deleteEdges(Vector<Edge> edgesToDelete) {
        this.removeEdges(edgesToDelete);
        this.completeEltSet.deleteEdges(edgesToDelete);
    }

    public synchronized boolean removeEdge(Edge e) {
        if (e == null) {
            return false;
        }
        return this.edges.remove(e);
    }

    public synchronized void removeEdges(Vector<Edge> edgesToRemove) {
        for (Edge e : edgesToRemove) {
            this.removeEdge(e);
        }
    }

    @Override
    public synchronized boolean deleteNode(Node node) {
        if (node == null) {
            return false;
        }
        this.removeNode(node);
        return this.completeEltSet.deleteNode(node);
    }

    @Override
    public synchronized void deleteNodes(Vector<Node> nodesToDelete) {
        this.removeNodes(nodesToDelete);
        this.completeEltSet.deleteNodes(nodesToDelete);
    }

    public synchronized boolean removeNode(Node node) {
        if (node == null) {
            return false;
        }
        if (!this.nodes.remove(node)) {
            return false;
        }
        String id = node.getID();
        if (id != null) {
            this.nodeIDRegistry.remove(id);
        }
        for (Edge e : node.getEdgeIterable()) {
            this.removeEdge(e);
        }
        return true;
    }

    public synchronized void removeNodes(Vector<Node> nodesToRemove) {
        for (Node n : nodesToRemove) {
            this.removeNode(n);
        }
    }

    public synchronized void removeAll() {
        super.clearAll();
    }

    @Override
    public synchronized void clearAll() {
        this.removeAll();
        this.completeEltSet.clearAll();
    }
}

