/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import com.touchgraph.graphlayout.graphelements.TGNodeQueue;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GESUtils {
    public static Hashtable<Node, Integer> calculateDistances(GraphEltSet ges, Node focusNode, int radius, int maxAddEdgeCount, int maxExpandEdgeCount, boolean unidirectional) {
        Node n;
        int currDist;
        Hashtable<Node, Integer> distHash = new Hashtable<Node, Integer>();
        distHash.put(focusNode, new Integer(0));
        TGNodeQueue nodeQ = new TGNodeQueue();
        nodeQ.push(focusNode);
        while (!nodeQ.isEmpty() && (currDist = distHash.get(n = nodeQ.pop()).intValue()) < radius) {
            for (Edge e : n.getEdgeIterable()) {
                if (n != e.getFrom() && unidirectional) continue;
                Node adjNode = e.getOtherEndpt(n);
                if (!ges.contains(e) || distHash.containsKey(adjNode) || adjNode.edgeCount() > maxAddEdgeCount) continue;
                if (adjNode.edgeCount() <= maxExpandEdgeCount) {
                    nodeQ.push(adjNode);
                }
                distHash.put(adjNode, new Integer(currDist + 1));
            }
        }
        return distHash;
    }

    public static Hashtable<Node, Integer> calculateDistances(GraphEltSet ges, Node focusNode, int radius) {
        return GESUtils.calculateDistances(ges, focusNode, radius, 1000, 1000, false);
    }

    public static Hashtable<Node, Integer> getLargestConnectedSubgraph(GraphEltSet ges) {
        int nodeCount = ges.nodeCount();
        if (nodeCount == 0) {
            return null;
        }
        Vector<Hashtable<Node, Integer>> subgraphVector = new Vector<Hashtable<Node, Integer>>();
        for (Node n : ges.getNodeIterable()) {
            boolean skipNode = false;
            for (Hashtable hashtable : subgraphVector) {
                if (!hashtable.contains(n)) continue;
                skipNode = true;
            }
            Hashtable<Node, Integer> subgraph = GESUtils.calculateDistances(ges, n, 1000);
            if (subgraph.size() > nodeCount / 2) {
                return subgraph;
            }
            if (skipNode) continue;
            subgraphVector.addElement(subgraph);
        }
        int maxSize = 0;
        int maxIndex = 0;
        for (int j = 0; j < subgraphVector.size(); ++j) {
            if (((Hashtable)subgraphVector.elementAt(j)).size() <= maxSize) continue;
            maxSize = ((Hashtable)subgraphVector.elementAt(j)).size();
            maxIndex = j;
        }
        return (Hashtable)subgraphVector.elementAt(maxIndex);
    }
}

