/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.GLEditUI;
import com.touchgraph.graphlayout.interaction.GLNavigateUI;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.TGUIManager;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SpringLayout;

public class GLPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public String zoomLabel = "Zoom";
    public String rotateLabel = "Rotate";
    public HVScroll hvScroll;
    public ZoomScroll zoomScroll;
    public RotateScroll rotateScroll;
    private Scrollbar horizontalSB;
    private Scrollbar verticalSB;
    private JSlider zoomSlider;
    private JSlider rotateSlider;
    private Panel topPanel;
    public PopupMenu glPopup;
    public PopupMenu nodePopup;
    public PopupMenu edgePopup;
    private HashMap<String, PopupMenu> nodePopups = new HashMap();
    public Node popupNode;
    public Edge popupEdge;
    public Hashtable<String, JSlider> sliderHash;
    protected TGPanel tgPanel;
    protected TGLensSet tgLensSet;
    protected TGUIManager tgUIManager;
    private JSlider currentSlider = null;
    private final Color textColor;
    private final Color backgroundColor;
    private final boolean useSliders;

    public GLPanel() {
        this(null, null);
    }

    public GLPanel(Color textColor, Color backgroundColor) {
        this(textColor, backgroundColor, true);
    }

    public GLPanel(Color textColor, Color backgroundColor, boolean useSliders) {
        this.useSliders = useSliders;
        if (textColor == null) {
            textColor = Color.BLACK;
        }
        this.textColor = textColor;
        if (backgroundColor == null) {
            backgroundColor = Color.WHITE;
        }
        this.backgroundColor = backgroundColor;
        this.setForeground(this.textColor);
        this.setBackground(this.backgroundColor);
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.sliderHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel(this.backgroundColor);
        this.tgPanel.setForeground(this.textColor);
        this.tgPanel.setBackground(this.backgroundColor);
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel, !useSliders);
        if (useSliders) {
            this.rotateScroll = new RotateScroll(this.tgPanel);
        }
        this.initialize();
    }

    public void initialize() {
        this.buildPanel();
        this.setupDefaultBackgroundPopup();
        this.setUpDefaultNodePopup();
        this.setUpDefaultEdgePopup();
        this.buildLens();
        this.tgPanel.setLensSet(this.tgLensSet);
        this.addUIs();
        this.setVisible(true);
    }

    public TGPanel getTGPanel() {
        return this.tgPanel;
    }

    public HVScroll getHVScroll() {
        return this.hvScroll;
    }

    public void setOffset(Point p) {
        this.hvScroll.setOffset(p);
    }

    public Point getOffset() {
        return this.hvScroll.getOffset();
    }

    public RotateScroll getRotateScroll() {
        return this.rotateScroll;
    }

    public void setRotationAngle(int angle) {
        this.rotateScroll.setRotationAngle(angle);
    }

    public int getRotationAngle() {
        return this.rotateScroll.getRotationAngle();
    }

    public ZoomScroll getZoomScroll() {
        return this.zoomScroll;
    }

    public void setZoomValue(int zoomValue) {
        this.zoomScroll.setZoomValue(zoomValue);
    }

    public int getZoomValue() {
        return this.zoomScroll.getZoomValue();
    }

    public PopupMenu getGLPopup() {
        return this.glPopup;
    }

    public void buildLens() {
        this.tgLensSet.addLens(this.hvScroll.getLens());
        if (this.zoomScroll != null) {
            this.tgLensSet.addLens(this.zoomScroll.getLens());
        }
        if (this.rotateScroll != null) {
            this.tgLensSet.addLens(this.rotateScroll.getLens());
        }
        this.tgLensSet.addLens(this.tgPanel.getAdjustOriginLens());
    }

    public void buildPanel() {
        this.horizontalSB = this.hvScroll.getHorizontalSB();
        this.verticalSB = this.hvScroll.getVerticalSB();
        if (this.useSliders) {
            this.zoomSlider = this.zoomScroll.getZoomSlider();
        }
        if (this.rotateScroll != null) {
            this.rotateSlider = this.rotateScroll.getRotateSlider();
        }
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        Panel scrollPanel = new Panel();
        scrollPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Panel modeSelectPanel = new Panel();
        modeSelectPanel.setLayout(new FlowLayout(1, 0, 0));
        this.topPanel = new Panel();
        this.topPanel.setLayout(new GridBagLayout());
        c.gridy = 0;
        c.fill = 2;
        c.gridx = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 0;
        c.weightx = 1.0;
        if (this.useSliders) {
            this.sliderHash.put(this.zoomLabel, this.zoomSlider);
            this.sliderHash.put(this.rotateLabel, this.rotateSlider);
            JPanel scrollselect = this.scrollSelectPanel(new String[]{this.zoomLabel, this.rotateLabel});
            this.topPanel.add((Component)scrollselect, c);
        }
        c.fill = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        scrollPanel.add((Component)this.tgPanel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        this.add(this.topPanel);
        this.add(scrollPanel);
        scrollPanel.setMinimumSize(new Dimension(200, 300));
        this.setMinimumSize(new Dimension(200, 300));
        this.topPanel.setMinimumSize(new Dimension(200, 300));
        layout.putConstraint("West", (Component)scrollPanel, 0, "West", (Component)this);
        layout.putConstraint("North", (Component)scrollPanel, 0, "North", (Component)this);
        layout.putConstraint("South", (Component)scrollPanel, 0, "South", (Component)this);
        layout.putConstraint("East", (Component)scrollPanel, 0, "East", (Component)this);
        layout.putConstraint("East", (Component)this.topPanel, 0, "East", (Component)this);
        layout.putConstraint("VerticalCenter", (Component)this.topPanel, 0, "VerticalCenter", (Component)this);
    }

    public void setBackgroundPopup(PopupMenu m) {
        this.remove(this.glPopup);
        this.glPopup = m;
        if (m != null) {
            this.add(m);
        }
    }

    public void setEdgePopup(PopupMenu m) {
        this.remove(this.edgePopup);
        this.edgePopup = m;
        if (m != null) {
            this.add(m);
        }
    }

    public void setNodePopup(String ID, PopupMenu m) {
        if (ID == null || ID.length() == 0) {
            this.remove(this.nodePopup);
            this.nodePopup = m;
            if (m != null) {
                this.add(m);
            }
        } else {
            PopupMenu old = this.nodePopups.remove(ID);
            if (old != null) {
                this.remove(old);
            }
            this.add(m);
            this.nodePopups.put(ID, m);
        }
    }

    private void setupDefaultBackgroundPopup() {
        this.glPopup = new PopupMenu();
        MenuItem menuItem = new MenuItem("Toggle Controls");
        ActionListener toggleControlsAction = new ActionListener(){
            boolean controlsVisible = true;

            public void actionPerformed(ActionEvent e) {
                this.controlsVisible = !this.controlsVisible;
                GLPanel.this.horizontalSB.setVisible(this.controlsVisible);
                GLPanel.this.verticalSB.setVisible(this.controlsVisible);
                GLPanel.this.topPanel.setVisible(this.controlsVisible);
                GLPanel.this.doLayout();
            }
        };
        menuItem.addActionListener(toggleControlsAction);
    }

    private void setUpDefaultNodePopup() {
        this.nodePopup = new PopupMenu();
        this.add(this.nodePopup);
        MenuItem menuItem = new MenuItem("Expand Node");
        ActionListener expandAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLPanel.this.popupNode != null) {
                    GLPanel.this.tgPanel.expandNode(GLPanel.this.popupNode);
                }
                GLPanel.this.tgPanel.setMaintainMouseOver(false);
                GLPanel.this.tgPanel.setMouseOverN(null);
                GLPanel.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(expandAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Collapse Node");
        ActionListener collapseAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLPanel.this.popupNode != null) {
                    GLPanel.this.tgPanel.collapseNode(GLPanel.this.popupNode);
                }
                GLPanel.this.tgPanel.setMaintainMouseOver(false);
                GLPanel.this.tgPanel.setMouseOverN(null);
                GLPanel.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(collapseAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Hide Node");
        ActionListener hideAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLPanel.this.popupNode != null) {
                    GLPanel.this.tgPanel.hideNode(GLPanel.this.popupNode);
                }
                GLPanel.this.tgPanel.setMaintainMouseOver(false);
                GLPanel.this.tgPanel.setMouseOverN(null);
                GLPanel.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(hideAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Center Node");
        ActionListener centerAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLPanel.this.popupNode != null) {
                    GLPanel.this.getHVScroll().slowScrollToCenter(GLPanel.this.popupNode);
                }
                GLPanel.this.tgPanel.setMaintainMouseOver(false);
                GLPanel.this.tgPanel.setMouseOverN(null);
                GLPanel.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(centerAction);
        this.nodePopup.add(menuItem);
    }

    private void setUpDefaultEdgePopup() {
        this.edgePopup = new PopupMenu();
        this.add(this.edgePopup);
        MenuItem menuItem = new MenuItem("Hide Edge");
        ActionListener hideAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GLPanel.this.popupEdge != null) {
                    GLPanel.this.tgPanel.hideEdge(GLPanel.this.popupEdge);
                }
                GLPanel.this.tgPanel.setMaintainMouseOver(false);
                GLPanel.this.tgPanel.setMouseOverN(null);
                GLPanel.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(hideAction);
        this.edgePopup.add(menuItem);
    }

    protected JPanel scrollSelectPanel(String[] sliderNames) {
        JPanel sbp = new JPanel(new BorderLayout());
        sbp.setBackground(this.backgroundColor);
        sbp.setForeground(this.textColor);
        JPanel labelPanel = new JPanel(new GridLayout(1, 2));
        labelPanel.setBackground(this.backgroundColor);
        labelPanel.setForeground(this.textColor);
        JPanel sliderPanel = new JPanel(new GridLayout(1, 2));
        sliderPanel.setBackground(this.backgroundColor);
        sliderPanel.setForeground(this.textColor);
        for (int i = 0; i < sliderNames.length; ++i) {
            JSlider slider = this.sliderHash.get(sliderNames[i]);
            slider.setBackground(this.backgroundColor);
            slider.setForeground(this.textColor);
            if (slider == null) continue;
            if (this.currentSlider == null) {
                this.currentSlider = slider;
            }
            JLabel label = new JLabel(sliderNames[i]);
            label.setBackground(this.backgroundColor);
            label.setForeground(this.textColor);
            labelPanel.add(label);
            sliderPanel.add(slider);
        }
        sbp.add((Component)labelPanel, "North");
        sbp.add((Component)sliderPanel, "Center");
        return sbp;
    }

    public void addUIs() {
        this.tgUIManager = new TGUIManager();
        GLEditUI editUI = new GLEditUI(this);
        GLNavigateUI navigateUI = new GLNavigateUI(this);
        this.tgUIManager.addUI(editUI, "Edit");
        this.tgUIManager.addUI(navigateUI, "Navigate");
        this.tgUIManager.activate("Navigate");
    }

    public void randomGraph() throws TGException {
        Node n1 = this.tgPanel.addNode();
        n1.setType(0);
        for (int i = 0; i < 249; ++i) {
            this.tgPanel.addNode();
        }
        for (Node n : this.tgPanel.getGES().getNodeIterable()) {
            for (int i = 0; i < 5; ++i) {
                Node r = this.tgPanel.getGES().getRandomNode();
                if (r == n || this.tgPanel.findEdge(r, n) != null) continue;
                this.tgPanel.addEdge(r, n, Edge.DEFAULT_LENGTH);
            }
        }
        this.tgPanel.setLocale(n1, 1);
        this.tgPanel.setSelect(n1);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getHVScroll().slowScrollToCenter(n1);
    }

    public static void main(String[] args) {
        final GLPanel glPanel = new GLPanel();
        try {
            glPanel.randomGraph();
        }
        catch (TGException e1) {
            e1.printStackTrace();
        }
        final Frame frame = new Frame("TouchGraph GraphLayout");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.remove(glPanel);
                frame.dispose();
            }
        });
        frame.add("Center", glPanel);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public void showPopup(int x, int y) {
        this.popupNode = this.tgPanel.getMouseOverN();
        this.popupEdge = this.tgPanel.getMouseOverE();
        if (this.popupNode != null) {
            String popup = this.popupNode.getPopup();
            System.out.println("Got node popup: " + popup);
            if (popup == null || popup.length() == 0) {
                if (this.nodePopup != null) {
                    this.tgPanel.setMaintainMouseOver(true);
                    this.nodePopup.show(this.tgPanel, x, y);
                }
            } else {
                PopupMenu p = this.nodePopups.get(popup);
                if (p != null) {
                    p.show(this.tgPanel, x, y);
                } else {
                    System.out.println("No popup defined for node: " + popup);
                }
            }
        } else if (this.popupEdge != null && this.edgePopup != null) {
            this.tgPanel.setMaintainMouseOver(true);
            this.edgePopup.show(this.tgPanel, x, y);
        } else if (this.glPopup != null) {
            // empty if block
        }
    }
}

