/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.ConnectionClosedException;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceiveTimedOutException;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.nio.NioDissipator;
import ibis.ipl.impl.nio.NioIbis;
import ibis.ipl.impl.nio.NioReceivePort;
import ibis.ipl.impl.nio.ThreadNioDissipator;
import ibis.util.Queue;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;

final class ThreadNioReceivePort
extends NioReceivePort {
    private ThreadNioDissipator current = null;
    private Queue readyDissipators = new Queue();
    private boolean closing = false;

    ThreadNioReceivePort(Ibis ibis, PortType type, String name, MessageUpcall upcall, ReceivePortConnectUpcall connUpcall, Properties props) throws IOException {
        super(ibis, type, name, upcall, connUpcall, props);
    }

    @Override
    synchronized void newConnection(SendPortIdentifier spi, Channel channel) throws IOException {
        if (!(channel instanceof ReadableByteChannel)) {
            throw new IOException("wrong channel type on creating connection");
        }
        this.addConnection(spi, new ThreadNioDissipator(((NioIbis)this.ibis).sendReceiveThread(), (ReadableByteChannel)channel));
    }

    @Override
    synchronized void errorOnRead(NioDissipator dissipator, Exception cause) {
        dissipator.info.close(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NioDissipator getReadyDissipator(long deadline) throws IOException {
        ThreadNioReceivePort threadNioReceivePort = this;
        synchronized (threadNioReceivePort) {
            if (this.current != null) {
                if (this.current.dataLeft()) {
                    this.readyDissipators.enqueue((Object)this.current);
                }
                this.current = null;
            }
        }
        while (true) {
            threadNioReceivePort = this;
            synchronized (threadNioReceivePort) {
                if (this.closing && this.connections.size() == 0) {
                    throw new ConnectionClosedException();
                }
            }
            ThreadNioDissipator dissipator = (ThreadNioDissipator)this.readyDissipators.dequeue(deadline);
            if (dissipator == null) {
                threadNioReceivePort = this;
                synchronized (threadNioReceivePort) {
                    if (this.closing && this.connections.size() == 0) {
                        throw new ConnectionClosedException();
                    }
                }
                throw new ReceiveTimedOutException("deadline passed while selecting dissipator");
            }
            try {
                if (!dissipator.messageWaiting()) continue;
                threadNioReceivePort = this;
                synchronized (threadNioReceivePort) {
                    this.current = dissipator;
                    return dissipator;
                }
            }
            catch (IOException e) {
                if (dissipator == null) continue;
                this.errorOnRead(dissipator, e);
                continue;
            }
            break;
        }
    }

    void addToReadyList(ThreadNioDissipator dissipator) {
        this.readyDissipators.enqueue((Object)dissipator);
    }

    @Override
    synchronized void closing() {
        this.closing = true;
    }
}

