/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.ConnectionRefusedException;
import ibis.ipl.ConnectionTimedOutException;
import ibis.ipl.PortType;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.nio.ChannelAccumulator;
import ibis.ipl.impl.nio.ChannelDissipator;
import ibis.ipl.impl.nio.ChannelFactory;
import ibis.ipl.impl.nio.NioIbis;
import ibis.ipl.impl.nio.NioReceivePort;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.Protocol;
import ibis.util.IPUtils;
import ibis.util.ThreadPool;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpChannelFactory
implements ChannelFactory,
Protocol {
    private static Logger logger = LoggerFactory.getLogger(TcpChannelFactory.class);
    private ServerSocketChannel ssc;
    private InetSocketAddress address;
    private NioIbis ibis;

    TcpChannelFactory(NioIbis ibis) throws IOException {
        int port = 0;
        InetAddress localAddress = IPUtils.getLocalHostAddress();
        this.ibis = ibis;
        this.ssc = ServerSocketChannel.open();
        this.address = new InetSocketAddress(localAddress, port);
        this.ssc.socket().bind(this.address);
        localAddress = this.ssc.socket().getInetAddress();
        port = this.ssc.socket().getLocalPort();
        this.address = new InetSocketAddress(localAddress, port);
        ThreadPool.createNew((Runnable)this, (String)"TcpChannelFactory");
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public void quit() throws IOException {
        this.ssc.close();
    }

    @Override
    public Channel connect(NioSendPort spi, ReceivePortIdentifier rpi, long timeoutMillis) throws IOException {
        long deadline = 0L;
        if (logger.isDebugEnabled()) {
            logger.debug("connecting \"" + spi + "\" to \"" + rpi + "\"");
        }
        if (timeoutMillis > 0L) {
            deadline = System.currentTimeMillis() + timeoutMillis;
        }
        InetSocketAddress addr = this.ibis.getAddress(rpi.ibis);
        while (true) {
            ChannelDissipator dissipator;
            byte reply;
            long time;
            SocketChannel channel;
            if (deadline == 0L) {
                channel = SocketChannel.open();
                channel.connect(addr);
            } else {
                time = System.currentTimeMillis();
                if (time >= deadline) {
                    logger.error("timeout on connecting");
                    throw new IOException("timeout on connecting");
                }
                channel = SocketChannel.open();
                channel.configureBlocking(false);
                channel.connect(addr);
                Selector selector = Selector.open();
                channel.register(selector, 8);
                if (selector.select(deadline - time) == 0) {
                    logger.error("timed out while connecting socket to receiver");
                    throw new ConnectionTimedOutException("timed out while connecting socket to receiver", (ibis.ipl.ReceivePortIdentifier)rpi);
                }
                if (!channel.finishConnect()) {
                    throw new IOException("finish connect failed while we made sure it would work");
                }
                selector.close();
                channel.configureBlocking(true);
            }
            channel.socket().setTcpNoDelay(true);
            ChannelAccumulator accumulator = new ChannelAccumulator(channel);
            accumulator.writeByte((byte)5);
            DataOutputStream d = new DataOutputStream((OutputStream)((Object)accumulator));
            d.writeUTF(rpi.name());
            spi.ident.writeTo((DataOutput)d);
            spi.type.writeTo((DataOutput)d);
            d.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("waiting for reply on connect");
            }
            if (timeoutMillis > 0L) {
                time = System.currentTimeMillis();
                if (time >= deadline) {
                    logger.warn("timeout on waiting for reply on connecting");
                    throw new IOException("timeout on waiting for reply");
                }
                channel.configureBlocking(false);
                Selector selector = Selector.open();
                channel.register(selector, 1);
                if (selector.select(deadline - time) == 0) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    logger.error("timed out while for reply from receiver");
                    throw new ConnectionTimedOutException("timed out while waiting for reply from receiver", (ibis.ipl.ReceivePortIdentifier)rpi);
                }
                selector.close();
                channel.configureBlocking(true);
            }
            if ((reply = (dissipator = new ChannelDissipator(channel)).readByte()) == 1) {
                logger.error("Receiver denied connection");
                channel.close();
                throw new ConnectionRefusedException("Receiver denied connection", (ibis.ipl.ReceivePortIdentifier)rpi);
            }
            if (reply == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("made new connection from \"" + spi + "\" to \"" + rpi + "\"");
                }
                channel.configureBlocking(true);
                return channel;
            }
            if (reply != 2) break;
            try {
                channel.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        logger.error("illegal opcode in ChannelFactory.connect()");
        throw new IOException("illegal opcode in ChannelFactory.connect()");
    }

    private void handleRequest(SocketChannel channel) {
        SendPortIdentifier spi = null;
        PortType capabilities = null;
        NioReceivePort rp = null;
        ChannelDissipator dissipator = new ChannelDissipator(channel);
        ChannelAccumulator accumulator = new ChannelAccumulator(channel);
        if (logger.isDebugEnabled()) {
            logger.debug("got new connection from " + channel.socket().getInetAddress() + ":" + channel.socket().getPort());
        }
        try {
            byte request = dissipator.readByte();
            if (request != 5) {
                logger.error("received unknown request");
                try {
                    dissipator.close();
                    accumulator.close();
                    channel.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            DataInputStream d = new DataInputStream((InputStream)((Object)dissipator));
            String name = d.readUTF();
            spi = new SendPortIdentifier((DataInput)d);
            capabilities = new PortType((DataInput)d);
            ReceivePortIdentifier rpi = new ReceivePortIdentifier(name, this.ibis.ident);
            rp = (NioReceivePort)this.ibis.findReceivePort(name);
            if (rp == null) {
                logger.error("could not find receiveport, connection denied");
                accumulator.writeByte((byte)1);
                accumulator.flush();
                channel.close();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("giving new connection to receiveport " + rpi);
            }
            byte reply = rp.connectionRequested(spi, capabilities, channel);
            accumulator.writeByte(reply);
            accumulator.flush();
            if (reply != 0) {
                channel.close();
                if (logger.isInfoEnabled()) {
                    logger.info("receiveport rejected connection");
                }
                return;
            }
        }
        catch (IOException e) {
            logger.error("got an exception on handling an incoming request, closing channel" + e);
            try {
                channel.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("set up new connection");
        }
    }

    @Override
    public void run() {
        SocketChannel channel = null;
        Thread.currentThread().setName("ChannelFactory");
        logger.info("ChannelFactory running on " + this.ssc);
        while (true) {
            try {
                channel = this.ssc.accept();
                channel.socket().setTcpNoDelay(true);
                channel.configureBlocking(true);
            }
            catch (ClosedChannelException e) {
                this.ssc = null;
                return;
            }
            catch (Exception e3) {
                try {
                    this.ssc.close();
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                logger.error("could not do accept");
                return;
            }
            this.handleRequest(channel);
        }
    }
}

