/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.nio.ThreadNioAccumulatorConnection;
import ibis.ipl.impl.nio.ThreadNioDissipator;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SendReceiveThread
implements Runnable {
    static final int INITIAL_ARRAY_SIZE = 8;
    private static Logger logger = LoggerFactory.getLogger(SendReceiveThread.class);
    private ArrayList<SelectableChannel> pendingChannels = new ArrayList();
    private ArrayList<Object> pendingAttachments = new ArrayList();
    private SelectionKey[] readyWriteKeys;
    private int nrOfReadyWriteKeys;
    private SelectionKey[] readyReadKeys;
    private int nrOfReadyReadKeys;
    private Selector selector = Selector.open();
    private boolean exit = false;

    SendReceiveThread() throws IOException {
        ThreadPool.createNew((Runnable)this, (String)"SendReceiveThread");
        this.readyWriteKeys = new SelectionKey[8];
        this.readyReadKeys = new SelectionKey[8];
    }

    synchronized SelectionKey register(SelectableChannel channel, Object attachment) throws IOException {
        SelectionKey key = null;
        this.pendingChannels.add(channel);
        this.pendingAttachments.add(attachment);
        channel.configureBlocking(false);
        this.selector.wakeup();
        while (key == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            key = channel.keyFor(this.selector);
        }
        return key;
    }

    void registerPendingChannels() {
        if (this.pendingChannels.size() == 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("registering " + this.pendingChannels.size() + " channels");
        }
        for (int i = 0; i < this.pendingChannels.size(); ++i) {
            SelectableChannel channel = this.pendingChannels.get(i);
            try {
                SelectionKey key = channel.register(this.selector, 0);
                key.attach(this.pendingAttachments.get(i));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.pendingChannels.clear();
        this.pendingAttachments.clear();
        this.notifyAll();
    }

    synchronized void enableWriting(SelectionKey key) {
        if (logger.isDebugEnabled()) {
            logger.debug("queueing write enable");
        }
        if (this.nrOfReadyWriteKeys == this.readyWriteKeys.length) {
            SelectionKey[] newKeys = new SelectionKey[this.readyWriteKeys.length * 2];
            for (int i = 0; i < this.readyWriteKeys.length; ++i) {
                newKeys[i] = this.readyWriteKeys[i];
            }
            this.readyWriteKeys = newKeys;
        }
        this.readyWriteKeys[this.nrOfReadyWriteKeys] = key;
        ++this.nrOfReadyWriteKeys;
        this.selector.wakeup();
    }

    synchronized void enableReading(SelectionKey key) {
        if (logger.isDebugEnabled()) {
            logger.debug("queueing read enable");
        }
        if (this.nrOfReadyReadKeys == this.readyReadKeys.length) {
            SelectionKey[] newKeys = new SelectionKey[this.readyReadKeys.length * 2];
            for (int i = 0; i < this.readyReadKeys.length; ++i) {
                newKeys[i] = this.readyReadKeys[i];
            }
            this.readyReadKeys = newKeys;
        }
        this.readyReadKeys[this.nrOfReadyReadKeys] = key;
        ++this.nrOfReadyReadKeys;
        this.selector.wakeup();
    }

    void handlePendingKeys() {
        int i;
        if (logger.isDebugEnabled() && (this.nrOfReadyWriteKeys != 0 || this.nrOfReadyReadKeys != 0)) {
            logger.debug("enabling " + this.nrOfReadyWriteKeys + " write keys and " + this.nrOfReadyReadKeys + " read keys");
        }
        for (i = 0; i < this.nrOfReadyWriteKeys; ++i) {
            try {
                this.readyWriteKeys[i].interestOps(4);
            }
            catch (CancelledKeyException e) {
                // empty catch block
            }
            this.readyWriteKeys[i] = null;
        }
        this.nrOfReadyWriteKeys = 0;
        for (i = 0; i < this.nrOfReadyReadKeys; ++i) {
            try {
                this.readyReadKeys[i].interestOps(1);
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
            this.readyReadKeys[i] = null;
        }
        this.nrOfReadyReadKeys = 0;
    }

    private void send(SelectionKey key) {
        ThreadNioAccumulatorConnection out = (ThreadNioAccumulatorConnection)((Object)key.attachment());
        out.threadSend();
    }

    private void receive(SelectionKey key) {
        ThreadNioDissipator in = (ThreadNioDissipator)key.attachment();
        in.doRead();
    }

    synchronized void quit() {
        this.exit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("send/receive thread");
        try {
            int max = Thread.currentThread().getThreadGroup().getMaxPriority();
            int current = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(Math.min(max, current + 1));
        }
        catch (Exception e) {
            // empty catch block
        }
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug("looking for work");
            }
            SendReceiveThread e = this;
            synchronized (e) {
                if (this.exit) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("done looking for work");
                    }
                    return;
                }
                this.registerPendingChannels();
                this.handlePendingKeys();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("doing a select on " + this.selector.keys().size() + " channels");
            }
            try {
                this.selector.select();
            }
            catch (IOException e2) {
                logger.warn("ibis.ipl.impl.nio.SendReceiveThread.run(): select failed with exception: " + e2);
            }
            catch (CancelledKeyException e3) {
                // empty catch block
            }
            if (logger.isDebugEnabled()) {
                logger.debug("selected " + this.selector.selectedKeys().size() + " channel(s)");
            }
            for (SelectionKey key : this.selector.selectedKeys()) {
                if (key.attachment() == null) continue;
                try {
                    if (key.isWritable()) {
                        this.send(key);
                    }
                    if (!key.isReadable()) continue;
                    this.receive(key);
                }
                catch (CancelledKeyException cancelledKeyException) {}
            }
            this.selector.selectedKeys().clear();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("done");
        }
    }
}

