/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.nio.NioAccumulator;
import ibis.ipl.impl.nio.NioAccumulatorConnection;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.SendBuffer;
import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NonBlockingChannelNioAccumulator
extends NioAccumulator {
    private static Logger logger = LoggerFactory.getLogger(NonBlockingChannelNioAccumulator.class);
    private final Selector selector = Selector.open();

    public NonBlockingChannelNioAccumulator(NioSendPort port) throws IOException {
        super(port);
    }

    @Override
    NioAccumulatorConnection newConnection(GatheringByteChannel channel, ReceivePortIdentifier peer) throws IOException {
        SelectableChannel sChannel = (SelectableChannel)((Object)channel);
        sChannel.configureBlocking(false);
        NioAccumulatorConnection result = new NioAccumulatorConnection(this.port, channel, peer);
        result.key = sChannel.register(this.selector, 0);
        result.key.attach((Object)result);
        return result;
    }

    @Override
    boolean doSend(SendBuffer buffer) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("doSend()");
        }
        if (this.nrOfConnections == 0) {
            logger.error("not connected");
            return true;
        }
        if (this.nrOfConnections == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("sending to 1 connection");
            }
            NioAccumulatorConnection connection = this.connections[0];
            try {
                if (!connection.addToSendList(buffer)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("add failed, making room and trying again");
                    }
                    this.doFlush();
                    connection.addToSendList(buffer);
                }
                connection.send();
            }
            catch (IOException e) {
                this.port.lostConnection(connection.target, e);
                --this.nrOfConnections;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("sending to " + this.nrOfConnections + " connections");
            }
            SendBuffer[] copies = SendBuffer.replicate(buffer, this.nrOfConnections);
            for (int i = 0; i < this.nrOfConnections; ++i) {
                NioAccumulatorConnection connection = this.connections[i];
                try {
                    if (!connection.addToSendList(copies[i])) {
                        this.doFlush(connection);
                        connection.addToSendList(copies[i]);
                    }
                    connection.send();
                    continue;
                }
                catch (IOException e) {
                    this.port.lostConnection(connection.target, e);
                    --this.nrOfConnections;
                    this.connections[i] = this.connections[this.nrOfConnections];
                    this.connections[this.nrOfConnections] = null;
                    SendBuffer.recycle(copies[this.nrOfConnections]);
                    --i;
                }
            }
        }
        return false;
    }

    @Override
    void doFlush() throws IOException {
        this.doFlush(null);
    }

    void doFlush(NioAccumulatorConnection connection) throws IOException {
        int i;
        int nrOfSendingConnections = 0;
        boolean done = false;
        if (logger.isDebugEnabled()) {
            if (connection == null) {
                logger.debug("doing a complete flush");
            } else {
                logger.debug("doing a flush of a single connection");
            }
        }
        if (logger.isDebugEnabled() && connection != null) {
            boolean found = false;
            for (int i2 = 0; i2 < this.nrOfConnections; ++i2) {
                if (this.connections[i2] != connection) continue;
                found = true;
            }
            if (!found) {
                throw new IOException("tried to flush non existing connection");
            }
        }
        for (i = 0; i < this.nrOfConnections; ++i) {
            NioAccumulatorConnection conn = this.connections[i];
            try {
                if (!conn.send()) {
                    conn.key.interestOps(4);
                    ++nrOfSendingConnections;
                    continue;
                }
                if (conn == connection) {
                    done = true;
                }
                conn.key.interestOps(0);
                continue;
            }
            catch (IOException e) {
                this.port.lostConnection(conn.target, e);
                --this.nrOfConnections;
                this.connections[i] = this.connections[this.nrOfConnections];
                this.connections[this.nrOfConnections] = null;
                --i;
            }
        }
        if (done || nrOfSendingConnections == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("flush done");
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("did one send for each connection, " + nrOfSendingConnections + " connections with data" + " left");
        }
        while (!done) {
            this.selector.selectedKeys().clear();
            try {
                this.selector.select();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (logger.isDebugEnabled()) {
                logger.debug("selected " + this.selector.selectedKeys().size() + " channels");
            }
            block9: for (SelectionKey key : this.selector.selectedKeys()) {
                NioAccumulatorConnection selected = (NioAccumulatorConnection)((Object)key.attachment());
                try {
                    if (!selected.send()) continue;
                    if (key.interestOps() == 0) {
                        throw new IOException("selected non-active channel");
                    }
                    key.interestOps(0);
                    if (selected != connection && --nrOfSendingConnections != 0) continue;
                    done = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("done flushing a connection, " + nrOfSendingConnections + " left");
                }
                catch (IOException e) {
                    --nrOfSendingConnections;
                    for (int i3 = 0; i3 < this.nrOfConnections; ++i3) {
                        if (connection != this.connections[i3]) continue;
                        this.port.lostConnection(this.connections[i3].target, e);
                        --this.nrOfConnections;
                        this.connections[i3] = this.connections[this.nrOfConnections];
                        this.connections[this.nrOfConnections] = null;
                        continue block9;
                    }
                }
            }
        }
        if (logger.isDebugEnabled() && connection == null) {
            for (i = 0; i < this.nrOfConnections; ++i) {
                NioAccumulatorConnection conn = this.connections[i];
                if (conn.empty()) continue;
                throw new IOException("data left to send after doing flush");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("flush done");
        }
    }
}

