/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.ReadableByteChannel;

public final class ChannelDissipator
extends DataInputStream {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    static final int BUFFER_SIZE = 1024;
    private ReadableByteChannel channel;
    private ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
    private long count = 0L;

    public ChannelDissipator(ReadableByteChannel channel) {
        this.buffer.limit(0);
        this.channel = channel;
    }

    public int bufferSize() {
        return 1024;
    }

    public int available() throws IOException {
        return this.buffer.remaining();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public long bytesRead() {
        return this.count;
    }

    public void resetBytesRead() {
        this.count = 0L;
    }

    private void readAtLeast(int minimum) throws IOException {
        this.buffer.compact();
        while (this.buffer.position() < minimum) {
            int count = this.channel.read(this.buffer);
            if (count == -1) {
                throw new IOException("eos read on reading from channel");
            }
            this.count += (long)count;
        }
        this.buffer.flip();
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public byte readByte() throws IOException {
        try {
            return this.buffer.get();
        }
        catch (BufferUnderflowException e) {
            this.readAtLeast(1);
            return this.buffer.get();
        }
    }

    public int read() throws IOException {
        try {
            return this.readByte() & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public char readChar() throws IOException {
        try {
            return this.buffer.getChar();
        }
        catch (BufferUnderflowException e) {
            this.readAtLeast(2);
            return this.buffer.getChar();
        }
    }

    public short readShort() throws IOException {
        try {
            return this.buffer.getShort();
        }
        catch (BufferUnderflowException e) {
            this.readAtLeast(2);
            return this.buffer.getShort();
        }
    }

    public int readInt() throws IOException {
        try {
            return this.buffer.getInt();
        }
        catch (BufferUnderflowException e) {
            this.readAtLeast(4);
            return this.buffer.getInt();
        }
    }

    public long readLong() throws IOException {
        try {
            return this.buffer.getLong();
        }
        catch (BufferUnderflowException e) {
            this.readAtLeast(8);
            return this.buffer.getLong();
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.buffer.getFloat();
        }
        catch (BufferUnderflowException e) {
            this.readAtLeast(4);
            return this.buffer.getFloat();
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.buffer.getDouble();
        }
        catch (BufferUnderflowException e) {
            this.readAtLeast(8);
            return this.buffer.getDouble();
        }
    }

    public void readArray(boolean[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readBoolean();
        }
    }

    public void readArray(byte[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readByte();
        }
    }

    public void readArray(char[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readChar();
        }
    }

    public void readArray(short[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readShort();
        }
    }

    public void readArray(int[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readInt();
        }
    }

    public void readArray(long[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readLong();
        }
    }

    public void readArray(float[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readFloat();
        }
    }

    public void readArray(double[] destination, int offset, int length) throws IOException {
        for (int i = offset; i < offset + length; ++i) {
            destination[i] = this.readDouble();
        }
    }

    public void readByteBuffer(ByteBuffer value) throws IOException, ReadOnlyBufferException {
        for (int i = value.position(); i < value.limit(); ++i) {
            value.put(this.readByte());
        }
    }
}

