/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.ConnectionClosedException;
import ibis.ipl.MessageUpcall;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceiveTimedOutException;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.nio.BlockingChannelNioDissipator;
import ibis.ipl.impl.nio.NioDissipator;
import ibis.ipl.impl.nio.NioReceivePort;
import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BlockingChannelNioReceivePort
extends NioReceivePort {
    static final int INITIAL_DISSIPATOR_SIZE = 8;
    private static Logger logger = LoggerFactory.getLogger(BlockingChannelNioReceivePort.class);
    private boolean closing = false;
    private BlockingChannelNioDissipator[] connections = new BlockingChannelNioDissipator[8];
    private int nrOfConnections = 0;

    BlockingChannelNioReceivePort(Ibis ibis, PortType type, String name, MessageUpcall upcall, ReceivePortConnectUpcall connUpcall, Properties properties) throws IOException {
        super(ibis, type, name, upcall, connUpcall, properties);
    }

    @Override
    synchronized void newConnection(SendPortIdentifier spi, Channel channel) throws IOException {
        if (!(channel instanceof ReadableByteChannel)) {
            throw new IOException("wrong channel type  on creating connection");
        }
        BlockingChannelNioDissipator dissipator = new BlockingChannelNioDissipator((ReadableByteChannel)channel);
        this.addConnection(spi, dissipator);
        if (this.nrOfConnections == this.connections.length) {
            BlockingChannelNioDissipator[] newConnections = new BlockingChannelNioDissipator[this.connections.length * 2];
            for (int i = 0; i < this.connections.length; ++i) {
                newConnections[i] = this.connections[i];
            }
            this.connections = newConnections;
        }
        this.connections[this.nrOfConnections] = dissipator;
        ++this.nrOfConnections;
        if (this.nrOfConnections > 1) {
            logger.warn("" + this.nrOfConnections + " connections to a " + "blocking receiveport, added connection from " + spi + " to " + this.ident);
        }
    }

    @Override
    synchronized void errorOnRead(NioDissipator dissipator, Exception cause) {
        dissipator.info.close(cause);
        for (int i = 0; i < this.nrOfConnections; ++i) {
            if (dissipator != this.connections[i]) continue;
            --this.nrOfConnections;
            this.connections[i] = this.connections[this.nrOfConnections];
            this.connections[this.nrOfConnections] = null;
            logger.debug("removed connection");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NioDissipator getReadyDissipator(long deadline) throws IOException {
        boolean deadlinePassed = false;
        NioDissipator dissipator = null;
        SelectionKey[] keys = new SelectionKey[]{};
        BlockingChannelNioReceivePort blockingChannelNioReceivePort = this;
        synchronized (blockingChannelNioReceivePort) {
            if (this.nrOfConnections == 0 && this.closing) {
                throw new ConnectionClosedException();
            }
            for (int i = 0; i < this.nrOfConnections; ++i) {
                BlockingChannelNioDissipator conn = this.connections[i];
                try {
                    if (!conn.messageWaiting()) continue;
                    return conn;
                }
                catch (IOException e) {
                    this.errorOnRead(conn, e);
                    --i;
                }
            }
            if (this.nrOfConnections == 1 && this.type.hasCapability("connection.onetoone") && deadline == 0L) {
                dissipator = this.connections[0];
            }
        }
        try {
            while (dissipator != null && !dissipator.messageWaiting()) {
                if (dissipator.available() != 0) continue;
                try {
                    dissipator.receive();
                }
                catch (IOException e) {
                    this.errorOnRead(dissipator, e);
                    dissipator = null;
                    break;
                }
            }
        }
        catch (IOException e) {
            this.errorOnRead(dissipator, e);
            dissipator = null;
        }
        if (dissipator != null) {
            return dissipator;
        }
        while (!deadlinePassed) {
            SelectableChannel sh;
            int i;
            Selector selector;
            long time;
            BlockingChannelNioReceivePort e = this;
            synchronized (e) {
                if (this.nrOfConnections == 0) {
                    if (this.closing) {
                        throw new ConnectionClosedException();
                    }
                    if (deadline == -1L) {
                        deadlinePassed = true;
                        continue;
                    }
                    if (deadline == 0L) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e2) {
                            // empty catch block
                        }
                        continue;
                    }
                    time = System.currentTimeMillis();
                    if (time >= deadline) {
                        deadlinePassed = true;
                    } else {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e3) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                selector = Selector.open();
                for (i = 0; i < this.nrOfConnections; ++i) {
                    sh = (SelectableChannel)((Object)this.connections[i].channel);
                    sh.configureBlocking(false);
                    sh.register(selector, 1, this.connections[i]);
                }
            }
            try {
                if (deadline == -1L) {
                    selector.selectNow();
                    deadlinePassed = true;
                } else if (deadline == 0L) {
                    selector.select();
                } else {
                    time = System.currentTimeMillis();
                    if (time >= deadline) {
                        deadlinePassed = true;
                    } else {
                        selector.select(deadline - time);
                    }
                }
            }
            catch (IOException e2) {
                logger.debug("Got IOException", (Throwable)e2);
            }
            keys = selector.selectedKeys().toArray(keys);
            selector.close();
            e = this;
            synchronized (e) {
                for (i = 0; i < this.nrOfConnections; ++i) {
                    sh = (SelectableChannel)((Object)this.connections[i].channel);
                    sh.configureBlocking(true);
                }
            }
            for (int i2 = 0; i2 < keys.length; ++i2) {
                dissipator = (BlockingChannelNioDissipator)keys[i2].attachment();
                SelectableChannel sh2 = (SelectableChannel)((Object)((BlockingChannelNioDissipator)dissipator).channel);
                sh2.configureBlocking(true);
                try {
                    dissipator.readFromChannel();
                    continue;
                }
                catch (IOException e4) {
                    this.errorOnRead(dissipator, e4);
                }
            }
            blockingChannelNioReceivePort = this;
            synchronized (blockingChannelNioReceivePort) {
                if (this.nrOfConnections == 0 && this.closing) {
                    throw new ConnectionClosedException();
                }
                for (int i3 = 0; i3 < this.nrOfConnections; ++i3) {
                    try {
                        if (!this.connections[i3].messageWaiting()) continue;
                        return this.connections[i3];
                    }
                    catch (IOException e5) {
                        this.errorOnRead(this.connections[i3], e5);
                        --i3;
                    }
                }
            }
        }
        throw new ReceiveTimedOutException("timeout while selecting dissipator");
    }

    @Override
    synchronized void closing() {
        this.closing = true;
    }
}

