/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.util.messagecombining;

import ibis.io.Replacer;
import ibis.ipl.SendPort;
import ibis.ipl.WriteMessage;
import ibis.ipl.util.messagecombining.CombiningWriteMessage;
import ibis.ipl.util.messagecombining.StoreArrayOutputStream;
import ibis.util.TypedProperties;
import java.io.IOException;

public class MessageCombiner {
    private SendPort sp;
    private StoreArrayOutputStream storeOut;
    private CombiningWriteMessage wm;
    private boolean wmInUse = false;
    private long currentMessageSize = 0L;

    public MessageCombiner(TypedProperties prop, SendPort sp) throws IOException {
        this.sp = sp;
        String ser = prop.getProperty("ibis.serialization");
        if (ser == null) {
            ser = "sun";
        }
        this.storeOut = new StoreArrayOutputStream();
        this.wm = new CombiningWriteMessage(this, this.storeOut, ser);
        this.wm.clear();
    }

    public synchronized WriteMessage newMessage() {
        while (this.wmInUse) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.wmInUse = true;
        this.currentMessageSize = this.storeOut.bytesWritten();
        return this.wm;
    }

    protected synchronized long messageIsFinished() {
        this.wmInUse = false;
        this.notifyAll();
        return this.storeOut.bytesWritten() - this.currentMessageSize;
    }

    protected SendPort getSendPort() {
        return this.sp;
    }

    public void setReplacer(Replacer r) throws IOException {
        this.wm.setReplacer(r);
    }

    public void sendAccumulatedMessages() throws IOException {
        this.storeOut.writeToMessage(this.sp.newMessage());
        this.wm.clear();
    }
}

