/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.server;

import ibis.ipl.server.ServerConnection;
import ibis.util.ThreadPool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerPipe
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnection.class);
    private final BufferedReader stdout;
    private final OutputStream stdin;
    private final PrintStream output;
    private final String outputPrefix;
    private String address = null;
    private IOException exception = null;

    ServerPipe(InputStream stdout, OutputStream stdin, PrintStream output, String outputPrefix) {
        this.stdout = new BufferedReader(new InputStreamReader(stdout));
        this.stdin = stdin;
        this.output = output;
        this.outputPrefix = outputPrefix;
        ThreadPool.createNew((Runnable)this, (String)"remote client");
    }

    synchronized String getAddress(long timeout) throws IOException {
        long deadline = System.currentTimeMillis() + timeout;
        while (this.address == null) {
            if (this.exception != null) {
                throw this.exception;
            }
            long waitTime = deadline - System.currentTimeMillis();
            if (waitTime > 0L) {
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {}
                continue;
            }
            throw new IOException("server did not produce address in time");
        }
        return this.address;
    }

    void end() {
        try {
            this.stdin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void setException(IOException exception) {
        this.exception = exception;
        this.notifyAll();
        this.end();
    }

    private synchronized void parseAddress(String line) {
        if (logger.isDebugEnabled()) {
            logger.debug("Parsing address from line: \"" + line + "\"");
        }
        int prefixIndex = line.lastIndexOf("IBIS SERVER RUNNING ON: ");
        int postfixIndex = line.indexOf("EOA");
        if (prefixIndex == -1 || postfixIndex == -1) {
            logger.warn("Address prefix+postfix not found in line \"" + line + "\"");
            this.output.println(line);
            return;
        }
        if (prefixIndex + "IBIS SERVER RUNNING ON: ".length() >= postfixIndex) {
            logger.warn("Invalid address in line \"" + line + "\"");
        }
        try {
            this.address = line.substring(prefixIndex + "IBIS SERVER RUNNING ON: ".length(), postfixIndex);
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn("Invalid address in line \"" + line + "\"");
            return;
        }
        this.notifyAll();
    }

    @Override
    public void run() {
        Object address = null;
        try {
            while (true) {
                String line;
                if ((line = this.stdout.readLine()) == null) {
                    this.setException(new IOException("server terminated"));
                    return;
                }
                if (address == null && line.contains("IBIS SERVER RUNNING ON: ")) {
                    this.parseAddress(line);
                    continue;
                }
                this.output.println(this.outputPrefix + line);
            }
        }
        catch (IOException e) {
            this.setException(e);
            return;
        }
    }
}

