/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.RegistryEventHandler;
import ibis.util.ThreadPool;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Upcaller
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Upcaller.class);
    private RegistryEventHandler handler;
    private final List<Event> pendingEvents;
    private boolean registryUpcallerEnabled = false;
    private boolean busyUpcaller = false;

    Upcaller(RegistryEventHandler handler) {
        this.handler = handler;
        this.pendingEvents = new LinkedList<Event>();
        ThreadPool.createNew((Runnable)this, (String)"upcaller");
    }

    synchronized void enableEvents() {
        this.registryUpcallerEnabled = true;
        this.notifyAll();
    }

    synchronized void disableEvents() {
        this.registryUpcallerEnabled = false;
        while (this.busyUpcaller) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    private synchronized void setBusyUpcaller() {
        this.busyUpcaller = true;
    }

    private synchronized void clearBusyUpcaller() {
        this.busyUpcaller = false;
        this.notifyAll();
    }

    private synchronized Event waitForEvent() {
        while (!this.registryUpcallerEnabled || this.pendingEvents.isEmpty()) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        return this.pendingEvents.remove(0);
    }

    synchronized void stop() {
        this.pendingEvents.add(null);
        this.notifyAll();
    }

    @Override
    public void run() {
        Event event;
        while ((event = this.waitForEvent()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("doing upcall for event: " + event);
            }
            this.setBusyUpcaller();
            try {
                switch (event.type) {
                    case 1: {
                        this.handler.joined(event.ibis);
                        break;
                    }
                    case 2: {
                        this.handler.left(event.ibis);
                        break;
                    }
                    case 3: {
                        this.handler.died(event.ibis);
                        break;
                    }
                    case 4: {
                        this.handler.gotSignal(event.string, event.ibis);
                        break;
                    }
                    case 5: {
                        this.handler.electionResult(event.string, event.ibis);
                        break;
                    }
                    default: {
                        logger.error("unknown event type: " + event.type);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error("error on handling event", t);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("upcall for event " + event + " done");
            }
            this.clearBusyUpcaller();
        }
        return;
    }

    synchronized void ibisJoined(IbisIdentifier ibis) {
        this.pendingEvents.add(new Event(1, ibis, null));
    }

    synchronized void ibisLeft(IbisIdentifier ibis) {
        this.pendingEvents.add(new Event(2, ibis, null));
    }

    synchronized void ibisDied(IbisIdentifier ibis) {
        this.pendingEvents.add(new Event(3, ibis, null));
    }

    synchronized void signal(String signal, IbisIdentifier source) {
        this.pendingEvents.add(new Event(4, source, signal));
    }

    synchronized void electionResult(String name, IbisIdentifier winner) {
        this.pendingEvents.add(new Event(5, winner, name));
    }

    private static final class Event {
        static final int JOIN = 1;
        static final int LEAVE = 2;
        static final int DIED = 3;
        static final int SIGNAL = 4;
        static final int ELECT = 5;
        int type;
        IbisIdentifier ibis;
        String string;

        Event(int type, IbisIdentifier ibis, String string) {
            this.type = type;
            this.ibis = ibis;
            this.string = string;
        }
    }
}

