/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.gossip.IbisComparator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;

public class Election {
    private final String name;
    private SortedSet<IbisIdentifier> candidates;

    Election(String name) {
        this.name = name;
        this.candidates = new TreeSet<IbisIdentifier>(new IbisComparator());
    }

    Election(DataInputStream in) throws IOException {
        this.name = in.readUTF();
        this.candidates = new TreeSet<IbisIdentifier>(new IbisComparator());
        int nrOfCandidates = in.readInt();
        if (nrOfCandidates < 0) {
            throw new IOException("negative candidate list value");
        }
        for (int i = 0; i < nrOfCandidates; ++i) {
            this.candidates.add(new IbisIdentifier((DataInput)in));
        }
    }

    synchronized void writeTo(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.candidates.size());
        for (IbisIdentifier candidate : this.candidates) {
            candidate.writeTo((DataOutput)out);
        }
    }

    synchronized void merge(Election other) {
        for (IbisIdentifier candidate : other.candidates) {
            this.candidates.add(candidate);
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized int nrOfCandidates() {
        return this.candidates.size();
    }

    public synchronized IbisIdentifier getWinner() {
        if (this.candidates.isEmpty()) {
            return null;
        }
        return this.candidates.first();
    }

    public synchronized IbisIdentifier[] getCandidates() {
        if (this.candidates.isEmpty()) {
            return new IbisIdentifier[0];
        }
        return this.candidates.toArray(new IbisIdentifier[0]);
    }

    public synchronized void addCandidate(IbisIdentifier candidate) {
        this.candidates.add(candidate);
    }

    public synchronized String toString() {
        String result = this.name + " candidates: ";
        for (IbisIdentifier candidate : this.candidates) {
            result = result + candidate;
        }
        return result;
    }
}

