/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.IbisConfigurationException;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.gossip.ARRG;
import ibis.ipl.registry.gossip.Broadcaster;
import ibis.ipl.registry.gossip.ElectionSet;
import ibis.ipl.registry.gossip.MemberSet;
import ibis.ipl.registry.gossip.Protocol;
import ibis.ipl.registry.gossip.Registry;
import ibis.ipl.registry.statistics.Statistics;
import ibis.ipl.support.Client;
import ibis.ipl.support.Connection;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import ibis.util.TypedProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommunicationHandler
implements Runnable {
    private static final int CONNECTION_BACKLOG = 25;
    static final int MAX_THREADS = 25;
    private static final int LEAVE_CONNECTION_TIMEOUT = 1000;
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final Logger logger = LoggerFactory.getLogger(CommunicationHandler.class);
    private final Registry registry;
    private final Statistics statistics;
    private final MemberSet pool;
    private final ElectionSet elections;
    private final VirtualSocketFactory socketFactory;
    private final VirtualServerSocket serverSocket;
    private final ARRG arrg;
    private final int nrOfLeavesSend;
    private final int gossipSize;
    private int currentNrOfThreads = 0;
    private int maxNrOfThreads = 0;

    CommunicationHandler(TypedProperties properties, Registry registry, MemberSet members, ElectionSet elections, Statistics statistics) throws IbisConfigurationException, IOException {
        this.registry = registry;
        this.pool = members;
        this.elections = elections;
        this.statistics = statistics;
        this.nrOfLeavesSend = properties.getIntProperty("ibis.registry.gossip.leaves.send");
        this.gossipSize = properties.getIntProperty("ibis.registry.gossip.gossip.count");
        String clientID = properties.getProperty("ibis.local.id");
        Client client = Client.getOrCreateClient(clientID, (Properties)properties, 0);
        this.socketFactory = client.getFactory();
        this.serverSocket = this.socketFactory.createServerSocket(0, 25, null);
        VirtualSocketAddress serverAddress = client.getServiceAddress(303);
        String[] bootstrapStringList = properties.getStringList("ibis.registry.gossip.bootstrap.list");
        VirtualSocketAddress[] bootstrapList = new VirtualSocketAddress[bootstrapStringList.length];
        for (int i = 0; i < bootstrapList.length; ++i) {
            bootstrapList[i] = new VirtualSocketAddress(bootstrapStringList[i]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("local address = " + this.serverSocket.getLocalSocketAddress());
            logger.debug("server address = " + serverAddress);
        }
        this.arrg = new ARRG(this.serverSocket.getLocalSocketAddress(), false, bootstrapList, serverAddress, registry.getPoolName(), this.socketFactory, statistics);
    }

    public void start() {
        this.arrg.start();
        this.createThread();
    }

    public void sendSignals(String signal, IbisIdentifier[] ibises) throws IOException {
        String errorMessage = null;
        for (IbisIdentifier ibis : ibises) {
            try {
                long start = System.currentTimeMillis();
                Connection connection = new Connection(ibis, 5000, true, this.socketFactory, 303);
                connection.out().writeByte(54);
                connection.out().writeByte(1);
                this.registry.getIbisIdentifier().writeTo((DataOutput)connection.out());
                connection.out().writeUTF(signal);
                connection.getAndCheckReply();
                connection.close();
                if (this.statistics == null) continue;
                this.statistics.add((byte)1, System.currentTimeMillis() - start, connection.read(), connection.written(), false);
            }
            catch (IOException e) {
                logger.error("could not send signal to " + ibis);
                errorMessage = errorMessage == null ? "could not send signal to: " + ibis : errorMessage + ", " + ibis;
            }
        }
        if (errorMessage != null) {
            throw new IOException(errorMessage);
        }
    }

    private void handleSignal(Connection connection) throws IOException {
        IbisIdentifier source = new IbisIdentifier((DataInput)connection.in());
        String signal = connection.in().readUTF();
        connection.sendOKReply();
        this.registry.signal(signal, source);
        connection.close();
    }

    public void gossip() {
        block5: {
            VirtualSocketAddress address = this.arrg.getRandomMember();
            if (address == null || address.equals((Object)this.serverSocket.getLocalSocketAddress())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("noone to gossip with, or (not) gossiping with self");
                }
                return;
            }
            try {
                long start = System.currentTimeMillis();
                Connection connection = new Connection(address, 5000, true, this.socketFactory);
                connection.out().writeByte(54);
                connection.out().writeByte(3);
                this.registry.getIbisIdentifier().writeTo((DataOutput)connection.out());
                this.pool.writeGossipData(connection.out(), this.gossipSize);
                this.elections.writeGossipData(connection.out());
                connection.getAndCheckReply();
                this.pool.readGossipData(connection.in());
                this.elections.readGossipData(connection.in());
                connection.close();
                if (this.statistics != null) {
                    this.statistics.add((byte)3, System.currentTimeMillis() - start, connection.read(), connection.written(), false);
                }
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("could not gossip with " + address, (Throwable)e);
            }
        }
    }

    private void handleGossip(Connection connection) throws IOException {
        IbisIdentifier peer = new IbisIdentifier((DataInput)connection.in());
        if (peer.equals((Object)this.registry.getIbisIdentifier())) {
            logger.error("eep! talking to ourselves");
            connection.closeWithError("talking to self");
        }
        if (!peer.poolName().equals(this.registry.getIbisIdentifier().poolName())) {
            connection.closeWithError("wrong pool");
        }
        this.pool.readGossipData(connection.in());
        this.elections.readGossipData(connection.in());
        connection.sendOKReply();
        this.pool.writeGossipData(connection.out(), this.gossipSize);
        this.elections.writeGossipData(connection.out());
        connection.close();
    }

    public void broadcastLeave() {
        VirtualSocketAddress[] addresses = this.arrg.getRandomMembers(this.nrOfLeavesSend);
        Broadcaster broadcaster = new Broadcaster(this, addresses);
        broadcaster.waitUntilDone();
    }

    void sendLeave(VirtualSocketAddress address) {
        if (address.equals((Object)this.serverSocket.getLocalSocketAddress())) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            Connection connection = new Connection(address, 1000, true, this.socketFactory);
            connection.out().writeByte(54);
            connection.out().writeByte(2);
            this.registry.getIbisIdentifier().writeTo((DataOutput)connection.out());
            connection.getAndCheckReply();
            connection.close();
            if (this.statistics != null) {
                this.statistics.add((byte)2, System.currentTimeMillis() - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            logger.debug(this.serverSocket.getLocalSocketAddress() + " could not send leave to " + address);
        }
    }

    private void handleLeave(Connection connection) throws IOException {
        IbisIdentifier ibis = new IbisIdentifier((DataInput)connection.in());
        connection.sendOKReply();
        this.pool.leave(ibis);
        connection.close();
    }

    public void ping(IbisIdentifier ibis) throws IOException {
        long start = System.currentTimeMillis();
        Connection connection = new Connection(ibis, 5000, true, this.socketFactory, 303);
        connection.out().writeByte(54);
        connection.out().writeByte(4);
        connection.getAndCheckReply();
        IbisIdentifier result = new IbisIdentifier((DataInput)connection.in());
        connection.close();
        if (!result.equals((Object)ibis)) {
            throw new IOException("tried to ping " + ibis + ", reached " + result + " instead");
        }
        if (this.statistics != null) {
            this.statistics.add((byte)4, System.currentTimeMillis() - start, connection.read(), connection.written(), false);
        }
    }

    private void handlePing(Connection connection) throws IOException {
        connection.sendOKReply();
        this.registry.getIbisIdentifier().writeTo((DataOutput)connection.out());
    }

    private void handleArrgGossip(Connection connection) throws IOException {
        String poolName = connection.in().readUTF();
        if (!poolName.equals(this.registry.getPoolName())) {
            connection.closeWithError("wrong pool name");
            return;
        }
        this.arrg.handleGossip(connection);
    }

    private synchronized void createThread() {
        while (this.currentNrOfThreads >= 25) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ThreadPool.createNew((Runnable)this, (String)"connection handler");
        ++this.currentNrOfThreads;
        if (this.currentNrOfThreads > this.maxNrOfThreads) {
            this.maxNrOfThreads = this.currentNrOfThreads;
        }
    }

    private synchronized void threadEnded() {
        --this.currentNrOfThreads;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        connection = null;
        try {
            if (CommunicationHandler.logger.isDebugEnabled()) {
                CommunicationHandler.logger.debug("accepting connection");
            }
            connection = new Connection(this.serverSocket);
            if (CommunicationHandler.logger.isDebugEnabled()) {
                CommunicationHandler.logger.debug("connection accepted");
            }
        }
        catch (IOException e) {
            if (this.registry.isStopped()) {
                this.threadEnded();
                return;
            }
            CommunicationHandler.logger.error("Accept failed, waiting a second, will retry", (Throwable)e);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException var3_4) {
                // empty catch block
            }
        }
        this.createThread();
        if (connection == null) {
            this.threadEnded();
            return;
        }
        start = System.currentTimeMillis();
        opcode = 0;
        try {
            magic = connection.in().readByte();
            if (magic != 54) {
                throw new IOException("Invalid header byte in accepting connection");
            }
            opcode = connection.in().readByte();
            if (CommunicationHandler.logger.isDebugEnabled()) {
                CommunicationHandler.logger.debug("got request, opcode = " + Protocol.opcodeString(opcode));
            }
            switch (opcode) {
                case 0: {
                    this.handleArrgGossip(connection);
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.handleSignal(connection);
                    ** break;
lbl40:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.handleLeave(connection);
                    ** break;
lbl44:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.handleGossip(connection);
                    ** break;
lbl48:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.handlePing(connection);
                    ** break;
lbl52:
                    // 1 sources

                    break;
                }
                default: {
                    CommunicationHandler.logger.error("unknown opcode: " + opcode);
                    break;
                }
            }
        }
        catch (IOException e) {
            CommunicationHandler.logger.error("error on handling connection", (Throwable)e);
        }
        finally {
            connection.close();
        }
        if (CommunicationHandler.logger.isDebugEnabled()) {
            CommunicationHandler.logger.debug("done handling request");
        }
        if (this.statistics != null) {
            this.statistics.add(opcode, System.currentTimeMillis() - start, connection.read(), connection.written(), true);
        }
        this.threadEnded();
    }

    VirtualSocketAddress getAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }
}

