/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.registry.gossip.ARRG;
import ibis.ipl.registry.gossip.Protocol;
import ibis.ipl.registry.statistics.Statistics;
import ibis.ipl.server.Service;
import ibis.ipl.support.Connection;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapService
implements Service,
Runnable {
    private static final int CONNECTION_BACKLOG = 50;
    static final int MAX_THREADS = 50;
    private static final Logger logger = LoggerFactory.getLogger(BootstrapService.class);
    private final VirtualServerSocket serverSocket;
    private final VirtualSocketFactory socketFactory;
    private final Map<String, ARRG> arrgs;
    private final boolean printErrors;
    private final boolean keepStatistics;
    private boolean ended = false;
    private int currentNrOfThreads = 0;
    private int maxNrOfThreads = 0;

    public BootstrapService(TypedProperties properties, VirtualSocketFactory socketFactory) throws IOException {
        this.socketFactory = socketFactory;
        this.printErrors = properties.getBooleanProperty("ibis.server.print.errors");
        this.keepStatistics = properties.getBooleanProperty("ibis.registry.gossip.statistics");
        this.arrgs = new HashMap<String, ARRG>();
        this.serverSocket = socketFactory.createServerSocket(303, 50, null);
        this.createThread();
    }

    @Override
    public String getServiceName() {
        return "bootstrap";
    }

    @Override
    public synchronized void end(long deadline) {
        this.ended = true;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        for (ARRG arrg : this.arrgs.values()) {
            arrg.end();
        }
        this.notifyAll();
    }

    synchronized boolean hasEnded() {
        return this.ended;
    }

    private synchronized ARRG getOrCreateARRG(String poolName) {
        ARRG result = this.arrgs.get(poolName);
        if (result == null) {
            Statistics statistics = null;
            if (this.keepStatistics) {
                statistics = new Statistics(Protocol.OPCODE_NAMES);
                statistics.setID("server", poolName);
                statistics.startWriting(60000L);
            }
            result = new ARRG(this.serverSocket.getLocalSocketAddress(), true, new VirtualSocketAddress[0], null, poolName, this.socketFactory, null);
            result.start();
            this.arrgs.put(poolName, result);
            System.out.println("Bootstrap service for new pool: " + poolName);
        }
        return result;
    }

    private synchronized void cleanup() {
        for (ARRG arrg : this.arrgs.values().toArray(new ARRG[0])) {
            if (!arrg.isDead()) continue;
            this.arrgs.remove(arrg.getPoolName());
        }
    }

    private synchronized void createThread() {
        while (this.currentNrOfThreads >= 50) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ThreadPool.createNew((Runnable)this, (String)"bootstrap service connection handler");
        ++this.currentNrOfThreads;
        if (logger.isTraceEnabled()) {
            logger.trace("now " + this.currentNrOfThreads + " threads");
        }
        if (this.currentNrOfThreads > this.maxNrOfThreads) {
            this.maxNrOfThreads = this.currentNrOfThreads;
        }
    }

    private synchronized void threadEnded() {
        --this.currentNrOfThreads;
        this.notifyAll();
    }

    @Override
    public void run() {
        Connection connection = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("accepting connection");
            }
            connection = new Connection(this.serverSocket);
            if (logger.isDebugEnabled()) {
                logger.debug("connection accepted");
            }
        }
        catch (IOException e) {
            if (this.hasEnded()) {
                this.threadEnded();
                return;
            }
            logger.error("Accept failed, waiting a second, will retry", (Throwable)e);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.createThread();
        if (connection == null) {
            this.threadEnded();
            return;
        }
        long start = System.currentTimeMillis();
        byte opcode = 0;
        try {
            byte magic = connection.in().readByte();
            if (magic != 54) {
                throw new IOException("Invalid header byte in accepting connection");
            }
            opcode = connection.in().readByte();
            if (logger.isDebugEnabled()) {
                logger.debug("got request, opcode = " + Protocol.opcodeString(opcode));
            }
            switch (opcode) {
                case 0: {
                    String poolName = connection.in().readUTF();
                    ARRG arrg = this.getOrCreateARRG(poolName);
                    arrg.handleGossip(connection);
                    connection.close();
                    Statistics statistics = arrg.getStatistics();
                    if (statistics != null) {
                        statistics.add(opcode, System.currentTimeMillis() - start, connection.read(), connection.written(), true);
                    }
                    break;
                }
                default: {
                    logger.error("unknown opcode: " + opcode);
                    connection.close();
                    break;
                }
            }
        }
        catch (IOException e) {
            if (this.printErrors) {
                System.out.println("error on handling connection");
                e.printStackTrace(System.out);
            }
            connection.close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("done handling request");
        }
        this.cleanup();
        this.threadEnded();
    }

    public String toString() {
        return "Bootstrap service on virtual port 303";
    }

    public Map<String, String> getStats() {
        return new HashMap<String, String>();
    }
}

