/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.smartsockets.virtual.VirtualSocketAddress;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

class ARRGCacheEntry {
    private final VirtualSocketAddress address;
    private final boolean arrgOnly;

    ARRGCacheEntry(VirtualSocketAddress address, boolean arrgOnly) {
        this.address = address;
        this.arrgOnly = arrgOnly;
    }

    ARRGCacheEntry(DataInputStream in) throws IOException {
        try {
            this.address = new VirtualSocketAddress((DataInput)in);
            this.arrgOnly = in.readBoolean();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            IOException exception = new IOException("could not read entry");
            exception.initCause(e);
            throw exception;
        }
    }

    void writeTo(DataOutputStream out) throws IOException {
        this.address.write((DataOutput)out);
        out.writeBoolean(this.arrgOnly);
    }

    public VirtualSocketAddress getAddress() {
        return this.address;
    }

    public boolean isArrgOnly() {
        return this.arrgOnly;
    }

    public boolean sameAddressAs(ARRGCacheEntry entry) {
        return this.address.equals((Object)entry.address);
    }

    public String toString() {
        return "address: " + this.address + ", arrg only: " + this.arrgOnly;
    }
}

