/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.client;

import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.registry.central.Event;
import ibis.ipl.registry.central.Protocol;
import ibis.ipl.registry.central.RegistryProperties;
import ibis.ipl.registry.central.client.CommunicationHandler;
import ibis.ipl.registry.central.client.Pool;
import ibis.ipl.registry.central.client.Upcaller;
import ibis.ipl.registry.statistics.Statistics;
import ibis.ipl.support.RemoteException;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Registry
extends ibis.ipl.registry.Registry {
    private static final Logger logger = LoggerFactory.getLogger(Registry.class);
    private final Upcaller upcaller;
    private final Statistics statistics;
    private final CommunicationHandler communicationHandler;
    private final Pool pool;
    private final ibis.ipl.impl.IbisIdentifier identifier;
    private final IbisCapabilities capabilities;
    private final ArrayList<IbisIdentifier> joinedIbises;
    private final ArrayList<IbisIdentifier> leftIbises;
    private final ArrayList<IbisIdentifier> diedIbises;
    private final ArrayList<String> signals;

    public Registry(IbisCapabilities capabilities, RegistryEventHandler eventHandler, Properties userProperties, byte[] data, String implementationVersion, Credentials credentials, byte[] tag) throws IbisConfigurationException, IOException {
        logger.debug("creating central registry");
        this.capabilities = capabilities;
        TypedProperties properties = RegistryProperties.getHardcodedProperties();
        properties.addProperties(userProperties);
        if (capabilities == null) {
            throw new IbisConfigurationException("Capabilities for registry not specified");
        }
        if ((capabilities.hasCapability("membership.unreliable") || capabilities.hasCapability("membership.totally.ordered")) && eventHandler == null) {
            this.joinedIbises = new ArrayList();
            this.leftIbises = new ArrayList();
            this.diedIbises = new ArrayList();
        } else {
            this.joinedIbises = null;
            this.leftIbises = null;
            this.diedIbises = null;
        }
        this.signals = capabilities.hasCapability("signals") && eventHandler == null ? new ArrayList() : null;
        this.upcaller = eventHandler != null ? new Upcaller(eventHandler) : null;
        if (properties.getBooleanProperty("ibis.registry.central.statistics")) {
            this.statistics = new Statistics(Protocol.OPCODE_NAMES);
            if (logger.isDebugEnabled()) {
                logger.debug("statistics: on");
            }
        } else {
            this.statistics = null;
            if (logger.isDebugEnabled()) {
                logger.debug("statistics: off");
            }
        }
        this.pool = new Pool(capabilities, properties, this, this.statistics);
        try {
            this.communicationHandler = new CommunicationHandler(properties, this.pool, this.statistics);
            this.identifier = this.communicationHandler.join(data, implementationVersion, credentials, tag);
            this.communicationHandler.bootstrap();
        }
        catch (RemoteException e) {
            throw new IbisConfigurationException(e.getMessage());
        }
        if (this.statistics != null) {
            this.statistics.setID(this.identifier.getID() + "@" + this.identifier.location(), this.pool.getName());
            this.statistics.startWriting(properties.getIntProperty("ibis.registry.central.statistics.interval") * 1000);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("registry for " + this.identifier + " initiated");
        }
    }

    @Override
    public ibis.ipl.impl.IbisIdentifier getIbisIdentifier() {
        return this.identifier;
    }

    public ibis.ipl.impl.IbisIdentifier elect(String electionName) throws IOException {
        return this.elect(electionName, 0L);
    }

    @Override
    public String[] wonElections() {
        return this.pool.wonElections(this.identifier);
    }

    public ibis.ipl.impl.IbisIdentifier elect(String electionName, long timeoutMillis) throws IOException {
        if (this.pool.isStopped()) {
            throw new IOException("cannot do election, registry already stopped");
        }
        if (!this.capabilities.hasCapability("elections.unreliable") && !this.capabilities.hasCapability("elections.strict")) {
            throw new IbisConfigurationException("No election support requested");
        }
        ibis.ipl.impl.IbisIdentifier result = this.pool.getElectionResult(electionName, -1L);
        if (result == null) {
            result = this.communicationHandler.elect(electionName, timeoutMillis);
        }
        return result;
    }

    public ibis.ipl.impl.IbisIdentifier getElectionResult(String election) throws IOException {
        return this.getElectionResult(election, 0L);
    }

    public ibis.ipl.impl.IbisIdentifier getElectionResult(String electionName, long timeoutMillis) throws IOException {
        if (this.pool.isStopped()) {
            throw new IOException("cannot do getElectionResult, registry already stopped");
        }
        if (!this.capabilities.hasCapability("elections.unreliable") && !this.capabilities.hasCapability("elections.strict")) {
            throw new IbisConfigurationException("No election support requested");
        }
        logger.debug("getting election result for: \"" + electionName + "\"");
        return this.pool.getElectionResult(electionName, timeoutMillis);
    }

    public void maybeDead(IbisIdentifier ibisIdentifier) throws IOException {
        if (this.pool.isStopped()) {
            throw new IOException("cannot do maybeDead, registry already stopped");
        }
        if (this.pool.mustReportMaybeDead(ibisIdentifier)) {
            this.communicationHandler.maybeDead(ibisIdentifier);
        }
    }

    public void assumeDead(IbisIdentifier ibisIdentifier) throws IOException {
        if (this.pool.isStopped()) {
            throw new IOException("cannot do assumeDead, registry already stopped");
        }
        this.communicationHandler.assumeDead(ibisIdentifier);
    }

    public void signal(String signal, IbisIdentifier ... ibisIdentifiers) throws IOException {
        if (this.pool.isStopped()) {
            throw new IOException("cannot send signals, registry already stopped");
        }
        if (!this.capabilities.hasCapability("signals")) {
            throw new IbisConfigurationException("No signal support requested");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("telling " + ibisIdentifiers.length + " ibisses a string: " + signal);
        }
        this.communicationHandler.signal(signal, ibisIdentifiers);
    }

    public synchronized IbisIdentifier[] joinedIbises() {
        if (this.joinedIbises == null) {
            throw new IbisConfigurationException("Resize downcalls not configured");
        }
        IbisIdentifier[] retval = this.joinedIbises.toArray(new IbisIdentifier[this.joinedIbises.size()]);
        this.joinedIbises.clear();
        return retval;
    }

    public synchronized IbisIdentifier[] leftIbises() {
        if (this.leftIbises == null) {
            throw new IbisConfigurationException("Resize downcalls not configured");
        }
        IbisIdentifier[] retval = this.leftIbises.toArray(new IbisIdentifier[this.leftIbises.size()]);
        this.leftIbises.clear();
        return retval;
    }

    public synchronized IbisIdentifier[] diedIbises() {
        if (this.diedIbises == null) {
            throw new IbisConfigurationException("Resize downcalls not configured");
        }
        IbisIdentifier[] retval = this.diedIbises.toArray(new IbisIdentifier[this.diedIbises.size()]);
        this.diedIbises.clear();
        return retval;
    }

    public synchronized String[] receivedSignals() {
        if (this.signals == null) {
            throw new IbisConfigurationException("Registry downcalls not configured");
        }
        String[] retval = this.signals.toArray(new String[this.signals.size()]);
        this.signals.clear();
        return retval;
    }

    public int getPoolSize() {
        if (!this.pool.isClosedWorld()) {
            throw new IbisConfigurationException("getPoolSize called but open world run");
        }
        return this.pool.getSize();
    }

    public String getPoolName() {
        return this.identifier.poolName();
    }

    public boolean isClosed() {
        return this.pool.isClosed();
    }

    public void waitUntilPoolClosed() {
        if (!this.pool.isClosedWorld()) {
            throw new IbisConfigurationException("waitForAll called but open world run");
        }
        this.pool.waitUntilPoolClosed();
    }

    public void enableEvents() {
        if (this.upcaller == null) {
            throw new IbisConfigurationException("Registry not configured to produce events");
        }
        this.upcaller.enableEvents();
    }

    public void disableEvents() {
        if (this.upcaller == null) {
            throw new IbisConfigurationException("Registry not configured to produce events");
        }
        this.upcaller.disableEvents();
    }

    @Override
    public long getSequenceNumber(String name) throws IOException {
        if (this.pool.isStopped()) {
            throw new IOException("cannot send signals, registry already stopped");
        }
        return this.communicationHandler.getSeqno(name);
    }

    @Override
    public void leave() throws IOException {
        if (this.pool.isStopped()) {
            throw new IOException("cannot leave, registry already stopped");
        }
        this.communicationHandler.leave();
        if (this.statistics != null) {
            this.statistics.write();
            this.statistics.end();
        }
    }

    synchronized void handleEvent(Event event) {
        if (logger.isDebugEnabled()) {
            logger.debug("new event passed to user: " + event);
        }
        if (event.getType() == 3) {
            boolean match = false;
            for (ibis.ipl.impl.IbisIdentifier ibis : event.getDestinations()) {
                if (!ibis.equals((Object)this.identifier)) continue;
                match = true;
            }
            if (!match) {
                return;
            }
        }
        if (this.upcaller != null) {
            this.upcaller.newEvent(event);
        }
        switch (event.getType()) {
            case 0: {
                if (this.joinedIbises == null) break;
                this.joinedIbises.add((IbisIdentifier)event.getIbis());
                break;
            }
            case 1: {
                if (this.leftIbises == null) break;
                this.leftIbises.add((IbisIdentifier)event.getIbis());
                break;
            }
            case 2: {
                if (this.leftIbises == null) break;
                this.leftIbises.add((IbisIdentifier)event.getIbis());
                break;
            }
            case 3: {
                if (this.signals == null) break;
                this.signals.add(event.getDescription());
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                logger.error("unknown event type in registry: " + event);
            }
        }
    }

    public Map<String, String> managementProperties() {
        return this.statistics.getMap();
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        String result = this.managementProperties().get(key);
        if (result == null) {
            throw new NoSuchPropertyException(key + " is not a valid property");
        }
        return result;
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("central registry does not have any properties that can be set");
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("central registry does not have any properties that can be set");
    }

    public void printManagementProperties(PrintStream stream) {
    }

    public boolean hasTerminated() {
        if (!this.capabilities.hasCapability("termination")) {
            throw new IbisConfigurationException("Registry not configured to support termination");
        }
        return this.pool.hasTerminated();
    }

    public void terminate() throws IOException {
        if (!this.capabilities.hasCapability("termination")) {
            throw new IbisConfigurationException("Registry not configured to support termination");
        }
        if (!this.pool.hasTerminated()) {
            this.communicationHandler.terminate();
        }
    }

    public IbisIdentifier waitUntilTerminated() {
        if (!this.capabilities.hasCapability("termination")) {
            throw new IbisConfigurationException("Registry not configured to support termination");
        }
        return this.pool.waitUntilTerminated();
    }

    public synchronized boolean getTerminated() {
        return this.hasTerminated();
    }

    public synchronized boolean getClosed() {
        return this.isClosed();
    }

    public String getTime() {
        return new Date() + "";
    }

    @Override
    public ibis.ipl.impl.IbisIdentifier getRandomPoolMember() {
        return this.pool.getRandomMember().getIbis();
    }
}

