/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.client;

import ibis.io.Conversion;
import ibis.ipl.Credentials;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.impl.Location;
import ibis.ipl.registry.central.Event;
import ibis.ipl.registry.central.Protocol;
import ibis.ipl.registry.central.client.Gossiper;
import ibis.ipl.registry.central.client.Heartbeat;
import ibis.ipl.registry.central.client.IterativeEventPusher;
import ibis.ipl.registry.central.client.Pool;
import ibis.ipl.registry.statistics.Statistics;
import ibis.ipl.server.ServerProperties;
import ibis.ipl.support.Client;
import ibis.ipl.support.Connection;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.ThreadPool;
import ibis.util.TypedProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommunicationHandler
implements Runnable {
    private static final int CONNECTION_BACKLOG = 10;
    private static final int MAX_THREADS = 10;
    private static final Logger logger = LoggerFactory.getLogger(CommunicationHandler.class);
    private final Heartbeat heartbeat;
    private final Client client;
    private final VirtualSocketFactory virtualSocketFactory;
    private final VirtualServerSocket serverSocket;
    private final VirtualSocketAddress serverAddress;
    private final Pool pool;
    private final TypedProperties properties;
    private final int timeout;
    private final Statistics statistics;
    private final boolean peerBootstrap;
    private final boolean gossip;
    private final boolean tree;
    private ibis.ipl.impl.IbisIdentifier identifier;
    private ibis.ipl.impl.IbisIdentifier[] bootstrapList;
    private int joinTime;
    private int currentNrOfThreads = 0;
    private int maxNrOfThreads = 0;

    CommunicationHandler(TypedProperties properties, Pool pool, Statistics statistics) throws IOException, IbisConfigurationException {
        this.properties = properties;
        this.pool = pool;
        this.statistics = statistics;
        if (properties.getProperty("ibis.server.address") == null) {
            throw new IbisConfigurationException("cannot initialize registry, property ibis.server.address is not specified");
        }
        this.gossip = properties.getBooleanProperty("ibis.registry.central.gossip");
        this.tree = properties.getBooleanProperty("ibis.registry.central.tree");
        if (this.gossip && this.tree) {
            throw new IbisConfigurationException("enabling both gossip and tree communication not allowed");
        }
        if (this.gossip) {
            this.peerBootstrap = true;
        } else if (this.tree) {
            this.peerBootstrap = false;
            if (properties.getBooleanProperty("ibis.registry.central.peer.bootstrap")) {
                throw new IbisConfigurationException("peer bootstrap not possible in combination with tree");
            }
        } else {
            this.peerBootstrap = properties.getBooleanProperty("ibis.registry.central.peer.bootstrap");
        }
        this.timeout = properties.getIntProperty("ibis.registry.central.client.connect.timeout") * 1000;
        String clientID = this.properties.getProperty("ibis.local.id");
        this.client = Client.getOrCreateClient(clientID, (Properties)properties, 0);
        this.virtualSocketFactory = this.client.getFactory();
        this.serverSocket = this.virtualSocketFactory.createServerSocket(302, 10, null);
        this.serverAddress = this.client.getServiceAddress(302);
        if (this.serverAddress == null) {
            throw new IOException("could not get address of server");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("local address = " + this.serverSocket.getLocalSocketAddress());
            logger.debug("server address = " + this.serverAddress);
        }
        long heartbeatInterval = properties.getIntProperty("ibis.registry.central.heartbeat.interval") * 1000;
        boolean exitOnServerFailure = properties.getBooleanProperty("ibis.registry.central.exit.on.server.failure");
        this.heartbeat = new Heartbeat(this, pool, heartbeatInterval, exitOnServerFailure);
        if (this.gossip) {
            long gossipInterval = properties.getIntProperty("ibis.registry.central.gossip.interval") * 1000;
            new Gossiper(this, pool, gossipInterval);
        }
        if (this.tree) {
            IterativeEventPusher eventPusher = new IterativeEventPusher(pool, this);
            eventPusher.setDaemon(true);
            eventPusher.start();
        }
    }

    synchronized ibis.ipl.impl.IbisIdentifier getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ibis.ipl.impl.IbisIdentifier join(byte[] implementationData, String implementationVersion, Credentials credentials, byte[] tag) throws IOException {
        Connection connection;
        long start = System.currentTimeMillis();
        long heartbeatInterval = this.properties.getIntProperty("ibis.registry.central.heartbeat.interval") * 1000;
        long eventPushInterval = this.properties.getIntProperty("ibis.registry.central.event.push.interval") * 1000;
        long gossipInterval = this.properties.getIntProperty("ibis.registry.central.gossip.interval") * 1000;
        boolean adaptGossipInterval = this.properties.getBooleanProperty("ibis.registry.central.adapt.gossip.interval");
        boolean keepStatistics = this.properties.getBooleanProperty("ibis.registry.central.statistics");
        long statisticsInterval = this.properties.getIntProperty("ibis.registry.central.statistics.interval") * 1000;
        boolean purgeHistory = this.properties.getBooleanProperty("ibis.registry.central.purge.history");
        VirtualSocketAddress address = this.serverSocket.getLocalSocketAddress();
        InetAddress[] preferred = null;
        if (address.machine().hasPublicAddress()) {
            InetSocketAddress[] sa = address.machine().getPublicAddresses();
            preferred = new InetAddress[sa.length];
            for (int i = 0; i < sa.length; ++i) {
                preferred[i] = sa[i].getAddress();
            }
        }
        Location location = Location.defaultLocation((Properties)this.properties, preferred);
        byte[] myAddress = address.toBytes();
        if (logger.isDebugEnabled()) {
            logger.debug("joining to " + this.pool.getName() + ", connecting to server");
        }
        try {
            connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        }
        catch (IOException e) {
            throw new IbisConfigurationException("Cannot connect to server at " + this.serverAddress + ", please check if it has been started");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sending join info to server");
        }
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(0);
            connection.out().writeUTF(ServerProperties.implementationVersion);
            connection.out().writeInt(myAddress.length);
            connection.out().write(myAddress);
            connection.out().writeUTF(this.pool.getName());
            connection.out().writeInt(implementationData.length);
            connection.out().write(implementationData);
            connection.out().writeUTF(implementationVersion);
            location.writeTo((DataOutput)connection.out());
            connection.out().writeBoolean(this.peerBootstrap);
            connection.out().writeLong(heartbeatInterval);
            connection.out().writeLong(eventPushInterval);
            connection.out().writeBoolean(this.gossip);
            connection.out().writeLong(gossipInterval);
            connection.out().writeBoolean(adaptGossipInterval);
            connection.out().writeBoolean(this.tree);
            connection.out().writeBoolean(this.pool.isClosedWorld());
            connection.out().writeInt(this.pool.getSize());
            connection.out().writeBoolean(keepStatistics);
            connection.out().writeLong(statisticsInterval);
            connection.out().writeBoolean(purgeHistory);
            byte[] credentialBytes = Conversion.object2byte((Object)credentials);
            connection.out().writeInt(credentialBytes.length);
            connection.out().write(credentialBytes);
            if (tag == null) {
                connection.out().writeInt(-1);
            } else {
                connection.out().writeInt(tag.length);
                connection.out().write(tag);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("reading join result info from server");
            }
            connection.getAndCheckReply();
            ibis.ipl.impl.IbisIdentifier identifier = new ibis.ipl.impl.IbisIdentifier((DataInput)connection.in());
            int joinTime = connection.in().readInt();
            int startOfEventListTime = connection.in().readInt();
            int listLength = connection.in().readInt();
            ibis.ipl.impl.IbisIdentifier[] bootstrapList = new ibis.ipl.impl.IbisIdentifier[listLength];
            for (int i = 0; i < listLength; ++i) {
                bootstrapList[i] = new ibis.ipl.impl.IbisIdentifier((DataInput)connection.in());
            }
            connection.close();
            this.heartbeat.resetDeadlines();
            CommunicationHandler i = this;
            synchronized (i) {
                this.identifier = identifier;
                this.bootstrapList = bootstrapList;
                this.joinTime = joinTime;
            }
            this.pool.purgeHistoryUpto(startOfEventListTime);
            if (logger.isDebugEnabled()) {
                logger.debug("join done, identifier = " + identifier);
            }
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)0, end - start, connection.read(), connection.written(), false);
            }
            ibis.ipl.impl.IbisIdentifier ibisIdentifier = identifier;
            return ibisIdentifier;
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
        finally {
            this.createThread();
        }
    }

    Client getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bootstrap() throws IOException {
        int joinTime;
        ibis.ipl.impl.IbisIdentifier[] bootstrapList;
        ibis.ipl.impl.IbisIdentifier identifier;
        if (!this.peerBootstrap) {
            return;
        }
        long start = System.currentTimeMillis();
        CommunicationHandler communicationHandler = this;
        synchronized (communicationHandler) {
            identifier = this.identifier;
            bootstrapList = this.bootstrapList;
            joinTime = this.joinTime;
        }
        for (ibis.ipl.impl.IbisIdentifier ibis : bootstrapList) {
            if (ibis.equals((Object)identifier)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("trying to bootstrap with data from " + ibis);
            }
            Connection connection = null;
            try {
                connection = new Connection(ibis, this.timeout, false, this.virtualSocketFactory, 302);
                connection.out().writeByte(54);
                connection.out().writeByte(12);
                identifier.writeTo((DataOutput)connection.out());
                connection.out().writeInt(joinTime);
                connection.out().flush();
                connection.getAndCheckReply();
                this.pool.init(connection.in());
                long end = System.currentTimeMillis();
                if (this.statistics != null) {
                    this.statistics.add((byte)12, end - start, connection.read(), connection.written(), false);
                }
                return;
            }
            catch (Exception e) {
                if (!logger.isInfoEnabled()) continue;
                logger.info("bootstrap with " + ibis + " failed, trying next one", (Throwable)e);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("could not bootstrap registry with any peer, trying server");
        }
        Connection connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(12);
            identifier.writeTo((DataOutput)connection.out());
            connection.out().writeInt(joinTime);
            connection.out().flush();
            connection.getAndCheckReply();
            this.pool.init(connection.in());
            connection.close();
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)12, end - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    public void signal(String signal, IbisIdentifier ... ibisses) throws IOException {
        long start = System.currentTimeMillis();
        Connection connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(7);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            connection.out().writeUTF(signal);
            connection.out().writeInt(ibisses.length);
            for (int i = 0; i < ibisses.length; ++i) {
                ((ibis.ipl.impl.IbisIdentifier)ibisses[i]).writeTo((DataOutput)connection.out());
            }
            connection.out().flush();
            connection.getAndCheckReply();
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("done telling " + ibisses.length + " ibisses a string: " + signal);
            }
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)7, end - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    public void terminate() throws IOException {
        long start = System.currentTimeMillis();
        Connection connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(14);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            connection.out().flush();
            connection.getAndCheckReply();
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("done terminating");
            }
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)14, end - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    public long getSeqno(String name) throws IOException {
        long start = System.currentTimeMillis();
        if (this.pool.isStopped()) {
            throw new IOException("cannot get sequence number, registry already stopped");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getting sequence number");
        }
        Connection connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(4);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            connection.out().writeUTF(name);
            connection.out().flush();
            connection.getAndCheckReply();
            long result = connection.in().readLong();
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("sequence number = " + result);
            }
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)4, end - start, connection.read(), connection.written(), false);
            }
            return result;
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    public void assumeDead(IbisIdentifier ibis) throws IOException {
        long start = System.currentTimeMillis();
        if (this.pool.isStopped()) {
            throw new IOException("cannot do assumeDead, registry already stopped");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("declaring " + ibis + " to be dead");
        }
        Connection connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(5);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            ((ibis.ipl.impl.IbisIdentifier)ibis).writeTo((DataOutput)connection.out());
            connection.out().flush();
            connection.getAndCheckReply();
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("done declaring " + ibis + " dead ");
            }
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)5, end - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    public void maybeDead(IbisIdentifier ibis) throws IOException {
        long start = System.currentTimeMillis();
        if (this.pool.isStopped()) {
            throw new IOException("cannot do maybeDead, registry already stopped");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("reporting " + ibis + " to possibly be dead");
        }
        Connection connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(6);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            ((ibis.ipl.impl.IbisIdentifier)ibis).writeTo((DataOutput)connection.out());
            connection.out().flush();
            connection.getAndCheckReply();
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("done reporting " + ibis + " to possibly be dead");
            }
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)6, end - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    boolean sendHeartBeat() {
        long start = System.currentTimeMillis();
        if (this.getIdentifier() == null) {
            return true;
        }
        if (this.pool.isStopped()) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("sending heartbeat to server");
        }
        Connection connection = null;
        try {
            connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
            connection.out().writeByte(54);
            connection.out().writeByte(13);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            connection.out().flush();
            connection.getAndCheckReply();
            connection.close();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)13, end - start, connection.read(), connection.written(), false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("sent heartbeat");
            }
            return true;
        }
        catch (Exception e) {
            if (connection != null) {
                connection.close();
            }
            if (logger.isInfoEnabled()) {
                logger.info(this.identifier + ": could not send heartbeat to server", (Throwable)e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("leaving pool");
        }
        long start = System.currentTimeMillis();
        Connection connection = new Connection(this.serverAddress, this.timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(1);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            connection.out().flush();
            connection.getAndCheckReply();
            connection.close();
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)1, end - start, connection.read(), connection.written(), false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("left");
            }
        }
        finally {
            connection.close();
            this.pool.stop();
            this.end();
            this.heartbeat.nudge();
        }
    }

    public ibis.ipl.impl.IbisIdentifier elect(String election, long timeout) throws IOException {
        long start = System.currentTimeMillis();
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        if (timeout == 0L) {
            timeout = this.timeout;
        }
        Connection connection = new Connection(this.serverAddress, (int)timeout, true, this.virtualSocketFactory);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(3);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            connection.out().writeUTF(election);
            connection.out().flush();
            connection.getAndCheckReply();
            ibis.ipl.impl.IbisIdentifier winner = new ibis.ipl.impl.IbisIdentifier((DataInput)connection.in());
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("election : \"" + election + "\" done, result = " + winner);
            }
            this.heartbeat.resetDeadlines();
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)3, end - start, connection.read(), connection.written(), false);
            }
            return winner;
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    void gossip(ibis.ipl.impl.IbisIdentifier ibis) throws IOException {
        long start = System.currentTimeMillis();
        if (ibis.equals((Object)this.getIdentifier())) {
            if (logger.isDebugEnabled()) {
                logger.debug("not gossiping with self");
            }
            return;
        }
        if (this.pool.isStopped()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("gossiping with " + ibis);
        }
        Connection connection = new Connection(ibis, this.timeout, false, this.virtualSocketFactory, 302);
        try {
            connection.out().writeByte(54);
            connection.out().writeByte(2);
            this.getIdentifier().writeTo((DataOutput)connection.out());
            int localTime = this.pool.getTime();
            connection.out().writeInt(localTime);
            connection.out().flush();
            connection.getAndCheckReply();
            int peerTime = connection.in().readInt();
            Event[] newEvents = null;
            if (peerTime > localTime) {
                int nrOfEvents;
                if (logger.isDebugEnabled()) {
                    logger.debug("localtime = " + localTime + ", peerTime = " + peerTime + ", receiving events");
                }
                if ((nrOfEvents = connection.in().readInt()) > 0) {
                    newEvents = new Event[nrOfEvents];
                    for (int i = 0; i < newEvents.length; ++i) {
                        newEvents[i] = new Event(connection.in());
                    }
                }
            } else if (peerTime < localTime) {
                if (logger.isDebugEnabled()) {
                    logger.debug("localtime = " + localTime + ", peerTime = " + peerTime + ", pushing events");
                }
                Event[] sendEvents = this.pool.getEventsFrom(peerTime);
                connection.out().writeInt(sendEvents.length);
                for (Event event : sendEvents) {
                    event.writeTo(connection.out());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("gossiping with " + ibis + " done, time now: " + this.pool.getTime());
            }
            connection.close();
            if (newEvents != null) {
                this.pool.newEventsReceived(newEvents);
            }
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add((byte)2, end - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            connection.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forward(ibis.ipl.impl.IbisIdentifier ibis) {
        byte opcode = 11;
        long start = System.currentTimeMillis();
        if (ibis.equals((Object)this.getIdentifier())) {
            logger.debug("not forwarding events to self");
            return;
        }
        if (this.pool.isStopped()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.identifier + ": forwarding to: " + ibis);
        }
        Connection connection = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("creating connection to push events to " + ibis);
            }
            connection = new Connection(ibis, this.timeout, false, this.virtualSocketFactory, 302);
            if (logger.isDebugEnabled()) {
                logger.debug("connection to " + ibis + " created");
            }
            connection.out().writeByte(54);
            connection.out().writeByte(opcode);
            connection.out().writeUTF(this.pool.getName());
            connection.out().flush();
            if (logger.isDebugEnabled()) {
                logger.debug("waiting for peer time of peer " + ibis);
            }
            boolean requestBootstrap = connection.in().readBoolean();
            int peerJoinTime = connection.in().readInt();
            int requestedEventTime = connection.in().readInt();
            if (logger.isDebugEnabled()) {
                logger.debug("request bootstrap = " + requestBootstrap + ", peerJoinTime = " + peerJoinTime + ", requested event time = " + requestedEventTime);
            }
            connection.sendOKReply();
            if (requestBootstrap) {
                if (logger.isDebugEnabled()) {
                    logger.debug("sending state");
                }
                this.pool.writeState(connection.out(), peerJoinTime);
            }
            Event[] events = this.pool.getEventsFrom(requestedEventTime);
            if (logger.isDebugEnabled()) {
                logger.debug("sending " + events.length + " entries to " + ibis);
            }
            connection.out().writeInt(events.length);
            for (int i = 0; i < events.length; ++i) {
                events[i].writeTo(connection.out());
            }
            connection.out().writeInt(-1);
            connection.close();
            if (logger.isDebugEnabled()) {
                logger.debug("connection to " + ibis + " closed");
            }
            if (this.statistics != null) {
                this.statistics.add(opcode, System.currentTimeMillis() - start, connection.read(), connection.written(), false);
            }
        }
        catch (IOException e) {
            if (this.pool.isMember(ibis)) {
                logger.error("cannot reach " + ibis + " to push events to", (Throwable)e);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void handleGossip(Connection connection) throws IOException {
        int nrOfEvents;
        if (logger.isDebugEnabled()) {
            logger.debug("got a gossip request");
        }
        ibis.ipl.impl.IbisIdentifier identifier = new ibis.ipl.impl.IbisIdentifier((DataInput)connection.in());
        String poolName = identifier.poolName();
        int peerTime = connection.in().readInt();
        if (!poolName.equals(this.pool.getName())) {
            logger.error("wrong pool: " + poolName + " instead of " + this.pool.getName());
            connection.closeWithError("wrong pool: " + poolName + " instead of " + this.pool.getName());
            return;
        }
        int localTime = this.pool.getTime();
        connection.sendOKReply();
        connection.out().writeInt(localTime);
        connection.out().flush();
        if (localTime > peerTime) {
            Event[] sendEvents = this.pool.getEventsFrom(peerTime);
            connection.out().writeInt(sendEvents.length);
            for (Event event : sendEvents) {
                event.writeTo(connection.out());
            }
            connection.out().flush();
        } else if (localTime < peerTime && (nrOfEvents = connection.in().readInt()) > 0) {
            Event[] newEvents = new Event[nrOfEvents];
            for (int i = 0; i < newEvents.length; ++i) {
                newEvents[i] = new Event(connection.in());
            }
            connection.close();
            this.pool.newEventsReceived(newEvents);
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePush(Connection connection, byte opcode) throws IOException {
        int joinTime;
        Event[] newEvents = null;
        if (logger.isDebugEnabled()) {
            logger.debug("got a push/forward/broadcast");
        }
        long start = System.currentTimeMillis();
        String poolName = connection.in().readUTF();
        long readPoolName = System.currentTimeMillis();
        if (!poolName.equals(this.pool.getName())) {
            logger.error("wrong pool: " + poolName + " instead of " + this.pool.getName());
            connection.closeWithError("wrong pool: " + poolName + " instead of " + this.pool.getName());
        }
        boolean requestBootstrap = !this.peerBootstrap && !this.pool.isInitialized();
        int nextRequiredEvent = this.pool.getNextRequiredEvent();
        long gatheredPoolData = System.currentTimeMillis();
        CommunicationHandler communicationHandler = this;
        synchronized (communicationHandler) {
            joinTime = this.joinTime;
        }
        long gatheredData = System.currentTimeMillis();
        connection.out().writeBoolean(requestBootstrap);
        connection.out().writeInt(joinTime);
        connection.out().writeInt(nextRequiredEvent);
        connection.out().flush();
        long sendData = System.currentTimeMillis();
        connection.getAndCheckReply();
        long gotReply = System.currentTimeMillis();
        if (requestBootstrap) {
            if (logger.isDebugEnabled()) {
                logger.debug("recieving bootstrap in push");
            }
            this.pool.init(connection.in());
        }
        long readBootstrap = System.currentTimeMillis();
        int events = connection.in().readInt();
        if (logger.isDebugEnabled()) {
            logger.debug("receiving " + events + " events");
        }
        if (events < 0) {
            connection.closeWithError("negative event value");
            return;
        }
        newEvents = new Event[events];
        for (int i = 0; i < newEvents.length; ++i) {
            newEvents[i] = new Event(connection.in());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("received event " + newEvents[i]);
        }
        int minEventTime = connection.in().readInt();
        long readEvents = System.currentTimeMillis();
        connection.close();
        long closedConnection = System.currentTimeMillis();
        if (newEvents != null) {
            this.pool.newEventsReceived(newEvents);
        }
        if (minEventTime != -1) {
            this.pool.purgeHistoryUpto(minEventTime);
        }
        long done = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            if (opcode == 10) {
                logger.debug("readPoolName = " + (readPoolName - start) + ", gatheredPoolData = " + (gatheredPoolData - readPoolName) + ", gatheredData = " + (gatheredData - gatheredPoolData) + ", sendData = " + (sendData - gatheredData) + ", gotReply = " + (gotReply - sendData) + ", readBootstrap = " + (readBootstrap - gotReply) + ", readEvents = " + (readEvents - readBootstrap) + ", closedConnection = " + (closedConnection - readEvents) + ", done = " + (done - closedConnection));
            }
            logger.debug("push handled");
        }
    }

    private void handlePing(Connection connection) throws IOException {
        ibis.ipl.impl.IbisIdentifier identifier;
        if (logger.isDebugEnabled()) {
            logger.debug("got a ping request");
        }
        if ((identifier = this.getIdentifier()) == null) {
            connection.closeWithError("ibis identifier not initialized yet");
            return;
        }
        connection.sendOKReply();
        this.getIdentifier().writeTo((DataOutput)connection.out());
        connection.out().flush();
        connection.close();
    }

    private void handleGetState(Connection connection) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("got a state request");
        }
        ibis.ipl.impl.IbisIdentifier identifier = new ibis.ipl.impl.IbisIdentifier((DataInput)connection.in());
        int joinTime = connection.in().readInt();
        String poolName = identifier.poolName();
        if (!poolName.equals(this.pool.getName())) {
            logger.error("wrong pool: " + poolName + " instead of " + this.pool.getName());
            connection.closeWithError("wrong pool: " + poolName + " instead of " + this.pool.getName());
            return;
        }
        if (!this.pool.isInitialized()) {
            connection.closeWithError("state not available");
            return;
        }
        connection.sendOKReply();
        this.pool.writeState(connection.out(), joinTime);
        connection.out().flush();
        connection.close();
    }

    private synchronized void createThread() {
        while (this.currentNrOfThreads >= 10) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ThreadPool.createNew((Runnable)this, (String)"client connection handler");
        ++this.currentNrOfThreads;
        if (this.currentNrOfThreads > this.maxNrOfThreads) {
            this.maxNrOfThreads = this.currentNrOfThreads;
        }
    }

    private synchronized void threadEnded() {
        --this.currentNrOfThreads;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection connection = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("accepting connection");
            }
            connection = new Connection(this.serverSocket);
            if (logger.isDebugEnabled()) {
                logger.debug("connection accepted");
            }
        }
        catch (IOException e) {
            if (this.pool.isStopped()) {
                this.threadEnded();
                return;
            }
            logger.error("Accept failed, waiting a second, will retry", (Throwable)e);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.createThread();
        if (connection == null) {
            this.threadEnded();
            return;
        }
        try {
            long start = System.currentTimeMillis();
            byte magic = connection.in().readByte();
            if (magic != 54) {
                throw new IOException("Invalid header byte in accepting connection");
            }
            byte opcode = connection.in().readByte();
            if (logger.isDebugEnabled() && opcode < 15) {
                logger.debug("received request: " + Protocol.OPCODE_NAMES[opcode]);
            }
            switch (opcode) {
                case 2: {
                    this.handleGossip(connection);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    this.handlePush(connection, opcode);
                    break;
                }
                case 8: {
                    this.handlePing(connection);
                    break;
                }
                case 12: {
                    this.handleGetState(connection);
                    break;
                }
                default: {
                    logger.error("unknown opcode in request: " + opcode);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("done handling request");
            }
            long end = System.currentTimeMillis();
            if (this.statistics != null) {
                this.statistics.add(opcode, end - start, connection.read(), connection.written(), true);
            }
        }
        catch (Throwable e) {
            logger.error("error on handling request", e);
        }
        finally {
            connection.close();
        }
        this.threadEnded();
    }

    void end() {
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.virtualSocketFactory.end();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

