/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central;

import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.central.Event;
import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.MemberSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;

public final class ListMemberSet
implements MemberSet {
    private final ArrayList<Member> list = new ArrayList();
    private final Random random = new Random();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void add(Member member) {
        this.list.add(member);
    }

    @Override
    public Member remove(IbisIdentifier identifier) {
        String ID = identifier.getID();
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).getID().equals(ID)) continue;
            Member result = this.list.remove(i);
            return result;
        }
        return null;
    }

    @Override
    public boolean contains(IbisIdentifier identifier) {
        String ID = identifier.getID();
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).getID().equals(ID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Member member) {
        return this.contains(member.getIbis());
    }

    @Override
    public Member get(IbisIdentifier identifier) {
        String ID = identifier.getID();
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).getID().equals(ID)) continue;
            return this.list.get(i);
        }
        return null;
    }

    @Override
    public Member get(String name) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).getIbis().name().equals(name)) continue;
            return this.list.get(i);
        }
        return null;
    }

    @Override
    public int getMinimumTime() {
        if (this.list.isEmpty()) {
            return -1;
        }
        int minimum = this.list.get(0).getCurrentTime();
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).getCurrentTime() >= minimum) continue;
            minimum = this.list.get(i).getCurrentTime();
        }
        return minimum;
    }

    @Override
    public Member getLeastRecentlySeen() {
        if (this.list.isEmpty()) {
            return null;
        }
        Member oldest = this.list.get(0);
        for (int i = 1; i < this.list.size(); ++i) {
            if (this.list.get(i).getTime() >= oldest.getTime()) continue;
            oldest = this.list.get(i);
        }
        return oldest;
    }

    @Override
    public Member get(int index) {
        if (index >= this.list.size()) {
            return null;
        }
        return this.list.get(index);
    }

    @Override
    public Member getRandom() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(this.random.nextInt(this.size()));
    }

    @Override
    public Member[] getRandom(int size) {
        ArrayList<Member> result = new ArrayList<Member>();
        BitSet added = new BitSet();
        if (size > this.list.size()) {
            size = this.list.size();
        }
        while (result.size() < size) {
            int next = this.random.nextInt(this.list.size());
            if (added.get(next)) continue;
            result.add(this.list.get(next));
            added.set(next);
        }
        return result.toArray(new Member[0]);
    }

    @Override
    public Member[] asArray() {
        return this.list.toArray(new Member[0]);
    }

    @Override
    public void init(DataInputStream in) throws IOException {
        int nrOfMembers = in.readInt();
        if (nrOfMembers < 0) {
            throw new IOException("negative list size recieved" + nrOfMembers);
        }
        for (int i = 0; i < nrOfMembers; ++i) {
            this.list.add(new Member(in));
        }
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeInt(this.list.size());
        for (Member member : this.list) {
            member.writeTo(out);
        }
    }

    @Override
    public List<Event> getJoinEvents() {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Member member : this.list) {
            result.add(member.getEvent());
        }
        return result;
    }

    @Override
    public Member[] getChildren(IbisIdentifier ibis) {
        return new Member[0];
    }

    @Override
    public Member[] getRootChildren() {
        return this.asArray();
    }
}

