/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.ipl.MessageUpcall;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReadMessage;
import ibis.ipl.ReceivePort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.smartsockets.SmartSocketsIbis;
import ibis.ipl.impl.smartsockets.SmartSocketsUltraLightReadMessage;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.servicelink.CallBack;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.util.ThreadPool;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartSocketsUltraLightReceivePort
implements ReceivePort,
CallBack,
Runnable {
    protected static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.smartsockets.ReceivePort");
    private final PortType type;
    private final String name;
    private final MessageUpcall upcall;
    private final ibis.ipl.ReceivePortIdentifier id;
    private boolean allowUpcalls = false;
    private boolean closed = false;
    private final LinkedList<SmartSocketsUltraLightReadMessage> messages = new LinkedList();

    SmartSocketsUltraLightReceivePort(SmartSocketsIbis ibis, PortType type, String name, MessageUpcall upcall, Properties properties) throws IOException {
        this.type = type;
        this.name = name;
        this.upcall = upcall;
        this.id = new ReceivePortIdentifier(name, ibis.ident);
        ServiceLink link = ibis.getServiceLink();
        if (link == null) {
            throw new IOException("No ServiceLink available");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Registering ultralight receive port " + name);
        }
        link.register(name, (CallBack)this);
        if (type.hasCapability("receive.autoupcalls") && upcall != null) {
            ThreadPool.createNew((Runnable)this, (String)"ConnectionHandler");
        }
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }

    public void close(long timeoutMillis) {
        this.close();
    }

    private synchronized boolean getClosed() {
        return this.closed;
    }

    public ibis.ipl.impl.SendPortIdentifier[] connectedTo() {
        return new ibis.ipl.impl.SendPortIdentifier[0];
    }

    public void disableConnections() {
    }

    public void enableConnections() {
    }

    public synchronized void disableMessageUpcalls() {
        this.allowUpcalls = false;
    }

    public synchronized void enableMessageUpcalls() {
        this.allowUpcalls = true;
        this.notifyAll();
    }

    public PortType getPortType() {
        return this.type;
    }

    public ibis.ipl.ReceivePortIdentifier identifier() {
        return this.id;
    }

    public ibis.ipl.impl.SendPortIdentifier[] lostConnections() {
        return new ibis.ipl.impl.SendPortIdentifier[0];
    }

    public String name() {
        return this.name;
    }

    public ibis.ipl.impl.SendPortIdentifier[] newConnections() {
        return new ibis.ipl.impl.SendPortIdentifier[0];
    }

    public ReadMessage poll() throws IOException {
        return null;
    }

    public ReadMessage receive() throws IOException {
        return this.receive(0L);
    }

    public ReadMessage receive(long timeoutMillis) throws IOException {
        return this.getMessage(timeoutMillis);
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        return null;
    }

    public Map<String, String> managementProperties() {
        return null;
    }

    public void printManagementProperties(PrintStream stream) {
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotMessage(DirectSocketAddress src, DirectSocketAddress srcProxy, int opcode, boolean returnToSender, byte[][] message) {
        logger.debug("Got message from + " + src);
        if (returnToSender || opcode != -559038737 || message == null || message.length == 0 || message[0] == null || message[0].length == 0) {
            logger.warn("Received malformed message from " + src.toString() + " (" + returnToSender + ", " + opcode + ", " + (message == null) + ", " + message.length + ", " + (message[0] == null) + ", " + message[0].length + ")");
            return;
        }
        IbisIdentifier source = null;
        try {
            source = new IbisIdentifier(message[0]);
            if (logger.isDebugEnabled()) {
                logger.debug("Message was send by " + source);
            }
        }
        catch (Exception e) {
            logger.warn("Message from contains malformed IbisIdentifier", (Throwable)e);
            return;
        }
        SmartSocketsUltraLightReadMessage rm = null;
        try {
            rm = new SmartSocketsUltraLightReadMessage(this, (SendPortIdentifier)new ibis.ipl.impl.SendPortIdentifier("anonymous", source), message[1]);
        }
        catch (Exception e) {
            logger.warn("Message from contains malformed data", (Throwable)e);
            return;
        }
        SmartSocketsUltraLightReceivePort smartSocketsUltraLightReceivePort = this;
        synchronized (smartSocketsUltraLightReceivePort) {
            this.messages.addLast(rm);
            this.notifyAll();
        }
    }

    private synchronized SmartSocketsUltraLightReadMessage getMessage(long timeout) {
        long endTime = System.currentTimeMillis() + timeout;
        while (!this.closed && this.messages.size() == 0) {
            if (timeout > 0L) {
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime <= 0L) break;
                try {
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {}
                continue;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (this.closed || this.messages.size() == 0) {
            return null;
        }
        return this.messages.removeFirst();
    }

    private synchronized boolean waitUntilUpcallAllowed() {
        while (!this.closed && !this.allowUpcalls) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUpcall(SmartSocketsUltraLightReadMessage message) {
        if (this.waitUntilUpcallAllowed()) {
            try {
                message.setInUpcall(true);
                this.upcall.upcall((ReadMessage)message);
            }
            catch (IOException e) {
                if (!message.isFinished()) {
                    message.finish(e);
                    return;
                }
                logger.error("Got unexpected exception in upcall, continuing ...", (Throwable)e);
            }
            catch (Throwable t) {
                if (!message.isFinished()) {
                    IOException ioex = new IOException("Got Throwable: " + t.getMessage());
                    ioex.initCause(t);
                    message.finish(ioex);
                }
                return;
            }
            finally {
                message.setInUpcall(false);
            }
        }
    }

    protected void newUpcallThread() {
        ThreadPool.createNew((Runnable)this, (String)"ConnectionHandler");
    }

    @Override
    public void run() {
        while (!this.getClosed()) {
            SmartSocketsUltraLightReadMessage message = this.getMessage(0L);
            if (message == null) continue;
            this.performUpcall(message);
            if (!message.finishCalledInUpcall()) continue;
            return;
        }
    }
}

