/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.io.BufferedArrayOutputStream;
import ibis.io.Conversion;
import ibis.io.DataOutputStream;
import ibis.io.OutputStreamSplitter;
import ibis.io.SplitterException;
import ibis.ipl.PortType;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.impl.Ibis;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.SendPort;
import ibis.ipl.impl.SendPortConnectionInfo;
import ibis.ipl.impl.SendPortIdentifier;
import ibis.ipl.impl.WriteMessage;
import ibis.ipl.impl.smartsockets.SmartSocketsIbis;
import ibis.ipl.impl.smartsockets.SmartSocketsProtocol;
import ibis.smartsockets.virtual.VirtualSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

final class SmartSocketsSendPort
extends SendPort
implements SmartSocketsProtocol {
    final OutputStreamSplitter splitter;
    final BufferedArrayOutputStream bufferedStream;

    SmartSocketsSendPort(Ibis ibis, PortType type, String name, SendPortDisconnectUpcall cU, Properties props) throws IOException {
        super(ibis, type, name, cU, props);
        this.splitter = new OutputStreamSplitter(!type.hasCapability("connection.onetoone") && !type.hasCapability("connection.manytoone"), type.hasCapability("connection.onetomany") || type.hasCapability("connection.manytomany"));
        this.bufferedStream = new BufferedArrayOutputStream((OutputStream)this.splitter);
        this.initStream((DataOutputStream)this.bufferedStream);
    }

    protected long totalWritten() {
        return this.splitter.bytesWritten();
    }

    protected void resetWritten() {
        this.splitter.resetBytesWritten();
    }

    SendPortIdentifier getIdent() {
        return this.ident;
    }

    protected SendPortConnectionInfo doConnect(ReceivePortIdentifier receiver, long timeoutMillis, boolean fillTimeout) throws IOException {
        VirtualSocket s = ((SmartSocketsIbis)this.ibis).connect(this, receiver, (int)timeoutMillis, fillTimeout);
        Conn c = new Conn(s, this, receiver);
        if (this.out != null) {
            this.out.writeByte((byte)1);
        }
        this.initStream((DataOutputStream)this.bufferedStream);
        return c;
    }

    protected void sendDisconnectMessage(ReceivePortIdentifier receiver, SendPortConnectionInfo conn) throws IOException {
        this.out.writeByte((byte)4);
        byte[] receiverBytes = receiver.toBytes();
        byte[] receiverLength = new byte[4];
        Conversion.defaultConversion.int2byte(receiverBytes.length, receiverLength, 0);
        this.out.writeArray(receiverLength);
        this.out.writeArray(receiverBytes);
        this.out.flush();
        Conn c = (Conn)conn;
        c.s.getInputStream().read();
    }

    protected void announceNewMessage() throws IOException {
        this.out.writeByte((byte)2);
        if (this.type.hasCapability("communication.numbered")) {
            this.out.writeLong(this.ibis.registry().getSequenceNumber(this.name));
        }
    }

    protected void finishMessage(WriteMessage w, long cnt) throws IOException {
        SplitterException e;
        if ((this.type.hasCapability("connection.onetomany") || this.type.hasCapability("connection.manytomany")) && (e = this.splitter.getExceptions()) != null) {
            this.gotSendException(w, (IOException)e);
        }
        super.finishMessage(w, cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSendException(WriteMessage w, IOException x) {
        ReceivePortIdentifier[] ports = null;
        SmartSocketsSendPort smartSocketsSendPort = this;
        synchronized (smartSocketsSendPort) {
            ports = this.receivers.keySet().toArray(new ReceivePortIdentifier[0]);
        }
        if (x instanceof SplitterException) {
            SplitterException e = (SplitterException)x;
            Exception[] exceptions = e.getExceptions();
            OutputStream[] streams = e.getStreams();
            block3: for (int i = 0; i < ports.length; ++i) {
                Conn c = (Conn)this.getInfo(ports[i]);
                for (int j = 0; j < streams.length; ++j) {
                    if (c.out != streams[j]) continue;
                    this.lostConnection(ports[i], exceptions[j]);
                    continue block3;
                }
            }
        } else {
            for (int i = 0; i < ports.length; ++i) {
                this.lostConnection(ports[i], x);
            }
        }
    }

    protected void closePort() {
        try {
            this.out.writeByte((byte)3);
            this.out.close();
            this.bufferedStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.out = null;
    }

    private class Conn
    extends SendPortConnectionInfo {
        VirtualSocket s;
        OutputStream out;

        Conn(VirtualSocket s, SmartSocketsSendPort port, ReceivePortIdentifier target) throws IOException {
            super((SendPort)port, target);
            this.s = s;
            this.out = s.getOutputStream();
            SmartSocketsSendPort.this.splitter.add(this.out);
        }

        public String connectionType() {
            return this.s.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeConnection() {
            try {
                this.s.close();
            }
            catch (Throwable e) {
            }
            finally {
                try {
                    SmartSocketsSendPort.this.splitter.remove(this.out);
                }
                catch (IOException e) {}
            }
        }
    }
}

