/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.smartsockets;

import ibis.ipl.CapabilitySet;
import ibis.ipl.Credentials;
import ibis.ipl.Ibis;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisFactory;
import ibis.ipl.IbisStarter;
import ibis.ipl.PortType;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.impl.smartsockets.SmartSocketsIbis;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartSocketsIbisStarter
extends IbisStarter {
    static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.smartsockets.SmartSocketsIbisStarter");
    static final IbisCapabilities ibisCapabilities = new IbisCapabilities(new String[]{"closed.world", "membership.totally.ordered", "membership.unreliable", "signals", "elections.unreliable", "elections.strict", "malleable", "termination"});
    static final PortType portCapabilities = new PortType(new String[]{"serialization.object.sun", "serialization.object.ibis", "serialization.object", "serialization.data", "serialization.byte", "communication.fifo", "communication.numbered", "communication.reliable", "connection.downcalls", "connection.upcalls", "connection.timeout", "connection.manytomany", "connection.manytoone", "connection.onetomany", "connection.onetoone", "connection.light", "connection.ultralight", "connection.direct", "receive.poll", "receive.autoupcalls", "receive.explicit", "receive.pollupcalls", "receive.timeout"});

    public SmartSocketsIbisStarter(String nickName, String iplVersion, String implementationVersion) {
        super(nickName, iplVersion, implementationVersion);
    }

    public boolean matches(IbisCapabilities capabilities, PortType[] types) {
        if (!capabilities.matchCapabilities((CapabilitySet)ibisCapabilities)) {
            return false;
        }
        for (PortType portType : types) {
            if (portType.matchCapabilities((CapabilitySet)portCapabilities)) continue;
            return false;
        }
        return true;
    }

    public CapabilitySet unmatchedIbisCapabilities(IbisCapabilities capabilities, PortType[] types) {
        return capabilities.unmatchedCapabilities((CapabilitySet)ibisCapabilities);
    }

    public PortType[] unmatchedPortTypes(IbisCapabilities capabilities, PortType[] types) {
        ArrayList<PortType> result = new ArrayList<PortType>();
        for (PortType portType : types) {
            if (portType.matchCapabilities((CapabilitySet)portCapabilities)) continue;
            result.add(portType);
        }
        return result.toArray(new PortType[0]);
    }

    public Ibis startIbis(IbisFactory factory, RegistryEventHandler registryEventHandler, Properties userProperties, IbisCapabilities capabilities, Credentials credentials, byte[] applicationTag, PortType[] portTypes, String specifiedSubImplementation) throws IbisCreationFailedException {
        return new SmartSocketsIbis(registryEventHandler, capabilities, credentials, applicationTag, portTypes, userProperties, this);
    }
}

