/*
 * Decompiled with CFR 0.152.
 */
package test.virtual.chain;

import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Server {
    private static final int DEFAULT_PORT = 5689;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage java test.chain.Server <#clients>");
            System.exit(1);
        }
        int machines = Integer.parseInt(args[0]);
        System.out.println("Expecting " + machines + " clients");
        Client[] clients = new Client[machines];
        try {
            int i;
            VirtualSocketFactory factory = VirtualSocketFactory.createSocketFactory();
            VirtualServerSocket ss = factory.createServerSocket(5689, 50, null);
            System.out.println("Created server socket at " + ss);
            for (int numclients = 0; numclients < machines; ++numclients) {
                System.out.println("Waiting for clients (" + numclients + "/" + machines + ")");
                VirtualSocket s = ss.accept();
                System.out.println("Got client " + numclients);
                clients[numclients] = new Client(s, numclients);
            }
            System.out.println("Got all clients: ");
            for (i = 0; i < clients.length; ++i) {
                System.out.println(clients[i].toString());
            }
            System.out.println();
            for (i = 0; i < clients.length; ++i) {
                System.out.println("Writing reply to " + i);
                clients[i].writeClients(clients);
                clients[i].close();
            }
            System.out.println("Done");
        }
        catch (Exception e) {
            System.out.println("Server got exception " + e);
            e.printStackTrace(System.err);
        }
    }

    private static class Client {
        final VirtualSocketAddress address;
        final int number;
        final VirtualSocket s;
        final DataInputStream in;
        final DataOutputStream out;

        Client(VirtualSocket s, int number) throws IOException {
            this.s = s;
            this.number = number;
            this.in = new DataInputStream(s.getInputStream());
            this.out = new DataOutputStream(s.getOutputStream());
            this.address = new VirtualSocketAddress(this.in.readUTF());
        }

        void writeClients(Client[] clients) throws IOException {
            this.out.writeInt(this.number);
            this.out.writeInt(clients.length);
            for (int i = 0; i < clients.length; ++i) {
                this.out.writeUTF(clients[i].address.toString());
            }
            this.out.flush();
        }

        void close() {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return this.number + " -> " + this.address.toString();
        }
    }
}

